/****************************************************************************
 **
 ** Copyright (C) 1992-2009 Nokia. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.launcher;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;

public class Delegate extends QItemDelegate {

    public static final int MARGE_HOR = 20; // Extra pixels on each side of text...
    public static final int MARGE_VER = 6;

    public Delegate(QSortFilterProxyModel model) {
        super(model);
        m_proxyModel = model;
    }

    private static String stripName(String s) {
        String[] tmp = s.split("\\.");
        return tmp[tmp.length - 1];
    }

    @Override
    public void paint(QPainter p, QStyleOptionViewItem option, QModelIndex index) {
        index = m_proxyModel.mapToSource(index);
        Launchable l = ((LaunchableListModel)m_proxyModel.sourceModel()).at(index);
        String text = stripName(l.name());
        boolean selected = (option.state().isSet(QStyle.StateFlag.State_Selected));
        QRectF rect = new QRectF(option.rect());
        rect.adjust(3, 1, -3, -1);
        if (selected) {
            Style.drawShadeButton(p, rect, new QStyle.State(QStyle.StateFlag.State_Enabled));
            Style.drawButtonOutline(p, rect, new QStyle.State(Style.StateFlag.State_Enabled));
        }

        Style.drawShadowText(p, rect.translated(0, -1), text, 2, 2);
    }

    @Override
    public QSize sizeHint(QStyleOptionViewItem option, QModelIndex index) {
        index = m_proxyModel.mapToSource(index);
        Launchable l = ((LaunchableListModel)m_proxyModel.sourceModel()).at(index);

        String text = stripName(l.name());

        QRect rect = option.fontMetrics().boundingRect(text);

        return new QSize(rect.width() + MARGE_HOR * 2, rect.height() + MARGE_VER * 2);
    }

    // Member variables...
    private QSortFilterProxyModel m_proxyModel;
}
