/****************************************************************************
**
** Copyright (C) 1992-2009 Nokia. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.


**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

package com.trolltech.demos.imageviewer;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;


public class LazyPixmap extends QObject {

    public static final QSize SMALL_SIZE = new QSize(32, 32);

    public Signal0 loaded = new Signal0();

    public LazyPixmap(String fileName) {
        this.fileName = fileName;
    }

    public void loadThumbNail() {
        QImage img = new QImage(fileName);

        assert !img.isNull();

        QImage small = (img.width() > SMALL_SIZE.width()
                        || img.height() > SMALL_SIZE.height())
                        ? img.scaled(SMALL_SIZE, Qt.AspectRatioMode.KeepAspectRatio, Qt.TransformationMode.SmoothTransformation)
                        : img.copy();

        synchronized(this){
            this.thumbNail = small;
            this.size = img.size();
            if(nativeId()!=0)
                loaded.emit();
        }
        img.dispose();
    }

    public synchronized QImage image() { return new QImage(fileName); }
    public synchronized QSize size() { return size; }
    public synchronized QImage thumbNail() { return thumbNail; }
    public synchronized boolean isValid() { return thumbNail != null; }

    private String fileName;
    private QImage thumbNail;
    private QSize size;
}
