/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QGUISIGNALMAPPER_H
#define QGUISIGNALMAPPER_H

#include <QtCore/QObject>
#include <QtCore/QSignalMapper>

class QGuiSignalMapper: public QSignalMapper
{
    Q_OBJECT
public:
    QGuiSignalMapper();
    QGuiSignalMapper(QObject *parent);

    void setMapping(QObject *sender, QWidget *widget);
    QObject *mapping(QWidget *widget) const;

private slots:
    void emitMapped(QWidget *);
    void emitMappedQWidget(QWidget *);

signals:
    void mappedQWidget(QWidget *widget);

private:
    void init();

    uint emittingMapped : 1;
    uint emittingMappedQWidget : 1;

};

#endif // QGUISIGNALMAPPER_H
