/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qguisignalmapper.h"

QGuiSignalMapper::QGuiSignalMapper() : QSignalMapper()
{
    init();
}

QGuiSignalMapper::QGuiSignalMapper(QObject *parent) : QSignalMapper(parent)
{
    init();
}

void QGuiSignalMapper::emitMapped(QWidget *widget)
{
    // Make sure we emit mapped() exactly once for each emission of mappedQWidget()
    if (!emittingMapped) {
        emittingMapped = true;
        emit mapped(widget);
        emittingMapped = false;
    }
}

void QGuiSignalMapper::emitMappedQWidget(QWidget *widget)
{
    // Make sure we emit mappedQWidget() exactly once for each emission of mapped()
    if (!emittingMappedQWidget) {
        emittingMappedQWidget = true;
        emit mappedQWidget(widget);
        emittingMappedQWidget = false;
    }
}

void QGuiSignalMapper::init()
{
    // mappedQWidget is a replacement for the original signal
    connect(this, SIGNAL(mappedQWidget(QWidget *)), this, SLOT(emitMapped(QWidget*)));
    connect(this, SIGNAL(mapped(QWidget *)), this, SLOT(emitMappedQWidget(QWidget*)));

    emittingMappedQWidget = false;
    emittingMapped = false;
}

void QGuiSignalMapper::setMapping(QObject *sender, QWidget *widget)
{
    QSignalMapper::setMapping(sender, widget);
}

QObject *QGuiSignalMapper::mapping(QWidget *widget) const
{
    return QSignalMapper::mapping(widget);
}
