/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of Qt Jambi.
**
** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "jambipropertysheet.h"

#include "qtjambi_core.h"
#include "qtjambi_utils.h"

#include <private/qdesigner_utils_p.h>

jclass class_NamedIntSet;
jclass class_List;

jfieldID field_value;
jfieldID field_names;
jfieldID field_isEnum;

jmethodID method_get;
jmethodID method_size;

using namespace qdesigner_internal;

QMap<QString, QVariant> jmap_to_qmap(JNIEnv *env, jobject jmap) {
    StaticCache *sc = StaticCache::instance(env);
    sc->resolveMap();
    jobjectArray entrySet = qtjambi_map_entryset_array(env, jmap);
    int size = env->CallIntMethod(jmap, sc->Map.size);
    QMap<QString, QVariant> qmap;
    for (int i=0; i<size; ++i) {
        QPair<jobject, jobject> entry = qtjambi_entryset_array_get(env, entrySet, i);
        QString name = qtjambi_to_qstring(env, (jstring) entry.first);
        int value = env->CallIntMethod(entry.second, sc->Integer.intValue);
        qmap.insert(name, value);
    }
    return qmap;
}

static void resolve(JNIEnv *env)
{
    static int resolved = 0;
    if (resolved)
        return;
    resolved = 1;

    ClassData classes[] = {
        { &class_NamedIntSet, "com/trolltech/tools/designer/NamedIntSet" },
        { &class_List, "java/util/List" },
        { 0, 0 }
    };
    qtjambi_resolve_classes(env, classes);
    Q_ASSERT(class_NamedIntSet);
    Q_ASSERT(class_List);

    FieldData fields[] = {
        { &class_NamedIntSet, &field_value,  "value",  "I" },
        { &class_NamedIntSet, &field_names,  "names",  "Ljava/util/Map;" },
        { &class_NamedIntSet, &field_isEnum, "isEnum", "Z" },
        { 0, 0, 0, 0 }
    };
    qtjambi_resolve_fields(env, fields);

    MethodData methods[] = {
        { &class_List, &method_get, "get", "(I)Ljava/lang/Object;" },
        { &class_List, &method_size, "size", "()I" },
        { 0, 0, 0, 0 }
    };
    qtjambi_resolve_methods(env, methods);
}

static QVariant qVariantEnum(JNIEnv *env, jobject value)
{
    EnumType et;
    et.value = (int) env->GetIntField(value, field_value);
    et.items = jmap_to_qmap(env, env->GetObjectField(value, field_names));

    QVariant variant;
    qVariantSetValue(variant, et);

    return variant;
}


static QVariant qVariantFlag(JNIEnv *env, jobject value)
{
    FlagType ft;
    ft.value = (int) env->GetIntField(value, field_value);
    ft.items = jmap_to_qmap(env, env->GetObjectField(value, field_names));

    QVariant variant;
    qVariantSetValue(variant, ft);

    return variant;
}


JambiPropertySheet::JambiPropertySheet(QObject *parent):
    QObject(parent)
{
    resolve(qtjambi_current_environment());
}


QVariant JambiPropertySheet::property(int index) const
{
    QVariant var = readProperty(index);

    if (var.isValid()) {
        JNIEnv *env = qtjambi_current_environment();
        jobject value = qtjambi_from_qvariant(env, var);

        jclass clazz = env->GetObjectClass(value);
        if (env->IsSameObject(clazz, class_NamedIntSet)) {
            if (env->GetBooleanField(value, field_isEnum))
                return qVariantEnum(env, value);
            else
                return qVariantFlag(env, value);
        } else if (env->IsAssignableFrom(clazz, class_List)) {
            StaticCache *sc = StaticCache::instance(env);
            sc->resolveString();

            // ### Workaround for 4.3 problem that QVariant conversion between c++ and java doesn't 
            // support QStringList. 
            int size = env->CallIntMethod(value, method_size);

            QStringList stringList;
            for (int i=0; i<size; ++i) {
                jobject element = env->CallObjectMethod(value, method_get, i);
                if (env->IsSameObject(env->GetObjectClass(element), sc->String.class_ref)) {
                    QString str = qtjambi_to_qstring(env, reinterpret_cast<jstring>(element));
                    stringList.append(str);
                } else {
                    break;
                }
                    
            }

            // If it was all strings, make a QVariant out of the list
            if (stringList.size() == size)
                var = QVariant(stringList);
        }
    } 

    return var;
}

void JambiPropertySheet::setProperty(int index, const QVariant &value)
{
    QVariant var = value;

    // ### Workaround for 4.3 problem that QVariant conversion between c++ and java doesn't 
    // support QStringList. 
    if (value.type() == QVariant::StringList) {
        QStringList list = qVariantValue<QStringList>(value);

        JNIEnv *env = qtjambi_current_environment();
        jobject java_list = qtjambi_arraylist_new(env, list.size());
        for (int i=0; i<list.size(); ++i) {
            jstring java_string = qtjambi_from_qstring(env, list.at(i));
            qtjambi_collection_add(env, java_list, java_string);                
        }

        var = qtjambi_to_qvariant(env, java_list);
    }

    writeProperty(index, var);
}

