/****************************************************************************
 **
 ** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.tools.designer.propertysheet;

import com.trolltech.qt.*;

public class Property implements Comparable {
    @SuppressWarnings("deprecation")
    public QtPropertyManager.Entry entry;

    public String groupName;
    public int subclassLevel;
    public boolean changed;
    public boolean visible;
    public boolean attribute;

    public boolean isPropertyInvokationTarget() {
        return false;
    }

    @SuppressWarnings("deprecation")
    public int compareTo(Object arg0) {
        assert arg0 instanceof Property;
        Property p = (Property) arg0;

        if (subclassLevel > p.subclassLevel)
            return -1;
        else if (subclassLevel < p.subclassLevel)
            return 1;
        else {
            int order = entry.sortOrder - p.entry.sortOrder;
            if (order == 0)
                return entry.name.compareTo(p.entry.name);
            return order;
        }
    }

    @SuppressWarnings("deprecation")
    public String toString() {
        return "{" + groupName + ":" + entry.name + "}";
    }
}
