/****************************************************************************
 **
 ** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.tools.designer.propertysheet;

import com.trolltech.qt.*;
import com.trolltech.qt.core.*;

public abstract class FakeProperty extends Property {

    @SuppressWarnings("deprecation")
    public FakeProperty(String name) {
        attribute = true;
        entry = new QtPropertyManager.Entry(name);
        try {
            entry.read = FakeProperty.class.getMethod("read");
            entry.write = FakeProperty.class.getMethod("write", Object.class);
            entry.designable = FakeProperty.class.getMethod("designable");
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            entry.reset = getClass().getMethod("reset");
        } catch (NoSuchMethodException e) {
            // not resettable...
        }
    }



    @Override
    public boolean isPropertyInvokationTarget() {
        return true;
    }

    public abstract Object read();
    public abstract void write(Object value);

    public boolean designable() { return true; }

    protected static int decideSubclassLevel(Class cl) {
        // Dynamically figure out superclass, just in case it _ever_ changes...
        int level = 0;
        while(cl != QObject.class) {
            level++;
            cl = cl.getSuperclass();
        }
        return level;
    }

}
