/****************************************************************************
 **
 ** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
 **
 ** This file is part of Qt Jambi.
 **
 ** ** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.

 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

package com.trolltech.launcher;

import com.trolltech.qt.core.*;
import com.trolltech.qt.gui.*;

public class Delegate extends QItemDelegate {

    public static final int MARGE_HOR = 20; // Extra pixels on each side of text...
    public static final int MARGE_VER = 6;

    public Delegate(LaunchableListModel model) {
        super(model);
        m_model = model;
    }

    private static String stripName(String s) {
        String[] tmp = s.split("\\.");
        return tmp[tmp.length - 1];
    }

    public void paint(QPainter p, QStyleOptionViewItem option, QModelIndex index) {
        Launchable l = m_model.at(index);
        String text = stripName(l.name());
        boolean selected = (option.state().isSet(QStyle.StateFlag.State_Selected));
        QRectF rect = new QRectF(option.rect());
        rect.adjust(3, 1, -3, -1);
        if (selected) {
            Style.drawShadeButton(p, rect, new QStyle.State(QStyle.StateFlag.State_Enabled));
            Style.drawButtonOutline(p, rect, new QStyle.State(Style.StateFlag.State_Enabled));
        }

        Style.drawShadowText(p, rect.translated(0, -1), text, 2, 2);
    }

    public QSize sizeHint(QStyleOptionViewItem option, QModelIndex index) {
        Launchable l = m_model.at(index);

        String text = stripName(l.name());

        QRect rect = option.fontMetrics().boundingRect(text);

        return new QSize(rect.width() + MARGE_HOR * 2, rect.height() + MARGE_VER * 2);
    }

    // Member variables...
    private LaunchableListModel m_model;
}
