/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi.prferences;

import com.trolltech.qtjambi.QtJambiConnection;
import com.trolltech.qtjambi.QtJambiPlugin;
import com.trolltech.qtjambi.QtJambiPropertyPreferenceHelper;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class QtJambiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite composite;
    private Text jambiPathText;
    private QtJambiPropertyPreferenceHelper helper = new QtJambiPropertyPreferenceHelper();

    protected IPreferenceStore doGetPreferenceStore() {
        return QtJambiPlugin.getInstance().getPreferenceStore();
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void update() {
        this.helper.juicDestinationFolderText.setEnabled(this.helper.juicUseDestinationFolder.getSelection());
        this.helper.juicCustomPrefixText.setEnabled(this.helper.juicUseCustomPrefix.getSelection());
    }

    protected Control createContents(final Composite composite) {
        QtJambiPlugin qtJambiPlugin = QtJambiPlugin.getInstance();
        this.composite = new Composite(composite, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(this.composite, 16);
        group.setText("Jambi Location");
        GridLayout gridLayout = new GridLayout(2, false);
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        group.setLayoutData((Object)gridData);
        this.jambiPathText = new Text((Composite)group, 2052);
        gridLayout = new GridData();
        gridLayout.grabExcessHorizontalSpace = true;
        gridLayout.horizontalAlignment = 4;
        gridLayout.verticalAlignment = 2;
        this.jambiPathText.setLayoutData((Object)gridLayout);
        gridData = new Button((Composite)group, 8);
        gridData.setText("Browse...");
        gridLayout = new GridData();
        gridLayout.grabExcessHorizontalSpace = false;
        gridLayout.horizontalAlignment = 4;
        gridLayout.verticalAlignment = 128;
        gridData.setLayoutData((Object)gridLayout);
        gridData.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                QtJambiPreferencePage.this.chooseJambiFolder(composite);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                QtJambiPreferencePage.this.chooseJambiFolder(composite);
            }
        });
        new Composite((Composite)group, 0);
        Button button = new Button((Composite)group, 8);
        button.setText("Validate...");
        button.setLayoutData((Object)gridLayout);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                QtJambiPreferencePage.this.validateJambiFolder(composite);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                QtJambiPreferencePage.this.validateJambiFolder(composite);
            }
        });
        this.helper.addJambiSection(this.composite);
        boolean bl = Boolean.parseBoolean(qtJambiPlugin.getPreferenceValue("JuicUseDestinationFolderProperty"));
        this.helper.juicDestinationFolderText.setText(qtJambiPlugin.getPreferenceValue("JuicDestinationFolderProperty"));
        this.helper.juicUseDestinationFolder.setSelection(bl);
        boolean bl2 = Boolean.parseBoolean(qtJambiPlugin.getPreferenceValue("JuicUseCustomPrefixProperty"));
        this.helper.juicCustomPrefixText.setText(qtJambiPlugin.getPreferenceValue("JuicCustomPrefixProperty"));
        this.helper.juicUseCustomPrefix.setSelection(bl2);
        this.jambiPathText.setText(qtJambiPlugin.getPreferenceValue("JambiLocationProperty"));
        this.update();
        return this.composite;
    }

    protected void performDefaults() {
        this.jambiPathText.setText(QtJambiPlugin.defaultValue("JambiLocationProperty"));
        this.helper.performDefaults();
        this.update();
    }

    public boolean performOk() {
        QtJambiPlugin qtJambiPlugin = QtJambiPlugin.getInstance();
        String string = qtJambiPlugin.getPreferenceValue("JambiLocationProperty");
        if (!string.equals(this.jambiPathText.getText())) {
            MessageBox messageBox = new MessageBox(this.getShell());
            messageBox.setMessage("Please restart Eclipse for the new settings to take effect");
            messageBox.open();
        }
        qtJambiPlugin.setPreferenceValue("JambiLocationProperty", this.jambiPathText.getText());
        qtJambiPlugin.setPreferenceValue("JuicDestinationFolderProperty", this.helper.juicDestinationFolderText.getText());
        qtJambiPlugin.setPreferenceValue("JuicCustomPrefixProperty", this.helper.juicUseCustomPrefix.getText());
        qtJambiPlugin.setPreferenceValue("JuicUseDestinationFolderProperty", this.helper.juicUseDestinationFolder.getSelection() + "");
        qtJambiPlugin.setPreferenceValue("JuicUseCustomPrefixProperty", this.helper.juicUseCustomPrefix.getSelection() + "");
        qtJambiPlugin.setPreferenceValue("JuicCustomPrefixProperty", this.helper.juicCustomPrefixText.getText() + "");
        try {
            JavaCore.setClasspathVariable((String)"JAMBI_LOCATION", (IPath)new Path(this.jambiPathText.getText()), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {
            QtJambiConnection.reportError((Exception)((Object)javaModelException), "Failed setting variable 'JAMBI_LOCATION'");
        }
        return true;
    }

    public void chooseJambiFolder(Composite composite) {
        String string = this.jambiPathText.getText();
        File file = new File(string);
        DirectoryDialog directoryDialog = new DirectoryDialog(composite.getShell());
        directoryDialog.setText("Select Qt Jambi Installation");
        directoryDialog.setFilterPath(file.getParent());
        String string2 = directoryDialog.open();
        if (string2 != null) {
            this.jambiPathText.setText(string2);
        }
    }

    public void validateJambiFolder(Composite composite) {
        if (QtJambiPlugin.jambiVersionCheck(this.jambiPathText.getText().trim(), this.getShell())) {
            MessageDialog.openInformation((Shell)composite.getShell(), (String)"Validating", (String)"Qt Jambi found and looks okay");
        }
    }
}

