/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private boolean valid;
    private int[] major = new int[3];
    private int minor = 0;
    private boolean hasMinor;
    private String versionString;

    public Version(String string) {
        this.versionString = string;
        Matcher matcher = Pattern.compile("([0-9]+\\.[0-9]+\\.[0-9]+_[0-9]+)|([0-9]+\\.[0-9]+\\.[0-9]+)").matcher(string);
        if (matcher.find()) {
            this.valid = true;
            Matcher matcher2 = Pattern.compile("[0-9]+").matcher(matcher.group());
            for (int i = 0; i < 3; ++i) {
                matcher2.find();
                this.major[i] = Integer.parseInt(matcher2.group());
            }
            if (matcher2.find()) {
                this.hasMinor = true;
                this.minor = Integer.parseInt(matcher2.group());
            }
        }
    }

    public String toString() {
        if (!this.valid) {
            return "Invalid version string: " + this.versionString;
        }
        String string = "";
        for (int i = 0; i < this.major.length; ++i) {
            if (i > 0) {
                string = string + ".";
            }
            string = string + this.major[i];
        }
        if (this.hasMinor) {
            string = string + "_" + this.minor;
        }
        return string;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasMinorVersion() {
        return this.hasMinor;
    }

    @Override
    public int compareTo(Version version) {
        for (int i = 0; i < this.major.length; ++i) {
            int n = this.major[i] - version.major[i];
            if (n == 0) continue;
            return n;
        }
        if (this.hasMinor && version.hasMinor) {
            return this.minor - version.minor;
        }
        return 0;
    }
}

