/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi.wizards;

import com.trolltech.common.QtWizardUtils;
import com.trolltech.qtjambi.wizards.pages.QtProjectWizardPage;
import com.trolltech.qtjambi.wizards.pages.QtWizardPage;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class QtProjectWizardBase
extends Wizard
implements INewWizard,
IPageChangedListener {
    protected QtProjectWizardPage projectPage;
    private int currentPage = 0;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.projectPage = new QtProjectWizardPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.projectPage);
    }

    public void setContainer(IWizardContainer iWizardContainer) {
        super.setContainer(iWizardContainer);
        if (this.getContainer() instanceof WizardDialog) {
            WizardDialog wizardDialog = (WizardDialog)this.getContainer();
            wizardDialog.addPageChangedListener((IPageChangedListener)this);
        }
    }

    public void pageChanged(PageChangedEvent pageChangedEvent) {
        IWizardPage[] iWizardPageArray = this.getPages();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        QtWizardPage qtWizardPage = (QtWizardPage)pageChangedEvent.getSelectedPage();
        for (int i = 0; i < iWizardPageArray.length; ++i) {
            QtWizardPage qtWizardPage2 = (QtWizardPage)iWizardPageArray[i];
            if (qtWizardPage2 == qtWizardPage) {
                qtWizardPage2.current((IProgressMonitor)nullProgressMonitor);
                this.currentPage = i;
                continue;
            }
            if (this.currentPage >= i) {
                qtWizardPage2.after((IProgressMonitor)nullProgressMonitor);
                continue;
            }
            qtWizardPage2.before((IProgressMonitor)nullProgressMonitor);
        }
    }

    private void role(int n, IWizardPage[] iWizardPageArray, int n2, IProgressMonitor iProgressMonitor) {
        if ((n += n2) < 0 || n >= iWizardPageArray.length) {
            return;
        }
        for (int i = 0; i < iWizardPageArray.length; ++i) {
            QtWizardPage qtWizardPage = (QtWizardPage)iWizardPageArray[i];
            if (qtWizardPage == iWizardPageArray[n]) {
                qtWizardPage.current(iProgressMonitor);
                continue;
            }
            if (n > i) {
                qtWizardPage.after(iProgressMonitor);
                continue;
            }
            qtWizardPage.before(iProgressMonitor);
        }
        this.role(n, iWizardPageArray, n2, iProgressMonitor);
    }

    private void addSystemLibsFile() {
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("qt_system_libs");
            IJavaProject iJavaProject = JavaCore.create((IProject)this.projectPage.getProject());
            IWorkspaceRoot iWorkspaceRoot = iJavaProject.getJavaModel().getWorkspace().getRoot();
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
            for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                if (iClasspathEntryArray[i].getEntryKind() != 3) continue;
                IResource iResource = iWorkspaceRoot.findMember(iClasspathEntryArray[i].getPath());
                File file = new File(iResource.getLocation().toOSString() + "/qt_system_libs");
                QtWizardUtils.addFile((InputStream)inputStream, (File)file);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean performFinish() {
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        this.role(this.currentPage, this.getPages(), 1, (IProgressMonitor)nullProgressMonitor);
        ((QtWizardPage)this.getPages()[this.getPages().length - 1]).after((IProgressMonitor)nullProgressMonitor);
        this.addSystemLibsFile();
        try {
            this.projectPage.getProject().refreshLocal(2, (IProgressMonitor)nullProgressMonitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    public boolean performCancel() {
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        this.role(this.currentPage, this.getPages(), -1, (IProgressMonitor)nullProgressMonitor);
        ((QtWizardPage)this.getPages()[0]).before((IProgressMonitor)nullProgressMonitor);
        return true;
    }
}

