/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi;

import com.trolltech.qtjambi.ProjectListener;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class QtJambiPlugin
extends AbstractUIPlugin
implements IStartup {
    private static QtJambiPlugin instance;
    public static final String JUIC_DESTINATIONFOLDER_PROPERTY = "JuicDestinationFolderProperty";
    public static final String JUIC_USEDESTINATIONFOLDER_PROPERTY = "JuicUseDestinationFolderProperty";
    public static final String JUIC_CUSTOM_PREFIX_PROPERTY = "JuicCustomPrefixProperty";
    public static final String JUIC_USE_CUSTOM_PREFIX_PROPERTY = "JuicUseCustomPrefixProperty";
    public static final String USE_WORKSPACE = "UseWorkspace";
    public static final String JUIC_BUILDER_ADDED = "JuicBuilderAdded";
    public static final String JAMBI_MINIMUM_VERSION = "4.3.0_01";

    public QtJambiPlugin() {
        if (instance == null) {
            instance = this;
        }
    }

    public static QtJambiPlugin getInstance() {
        return instance;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"QtJambi", (String)string);
    }

    public void earlyStartup() {
        ProjectListener projectListener = new ProjectListener();
        JavaCore.addElementChangedListener((IElementChangedListener)projectListener, (int)1);
        projectListener.addBuilderToAllProjects();
    }

    public String getPreferenceValue(String string) {
        String string2 = this.getPreferenceStore().getString(string);
        if (string2 == null || string2.equals("")) {
            return QtJambiPlugin.defaultValue(string);
        }
        return string2;
    }

    public void setPreferenceValue(String string, String string2) {
        this.getPreferenceStore().setValue(string, string2);
    }

    public static String defaultValue(String string) {
        if (string.equals("JambiLocationProperty")) {
            return "/jambi";
        }
        if (string.equals(JUIC_DESTINATIONFOLDER_PROPERTY)) {
            return "Generated JUIC files";
        }
        if (string.equals(JUIC_USEDESTINATIONFOLDER_PROPERTY)) {
            return "true";
        }
        if (string.equals(USE_WORKSPACE)) {
            return "true";
        }
        if (string.equals(JUIC_CUSTOM_PREFIX_PROPERTY)) {
            return "Ui_";
        }
        if (string.equals(JUIC_USE_CUSTOM_PREFIX_PROPERTY)) {
            return "false";
        }
        throw new IllegalArgumentException("Attempted to fetch default value for unknown property '" + string + "'");
    }

    public static boolean incompatibleVersion(String string, String string2) {
        return string.compareTo(string2) < 0;
    }

    public static boolean newMinorVersion(String string, String string2) {
        String string3;
        String string4 = string.substring(0, 3);
        return string4.compareTo(string3 = string2.substring(0, 3)) > 0;
    }

    public static boolean jambiVersionCheck(String string, Shell shell) {
        try {
            String string2 = string;
            if (!string2.endsWith("/") && !string2.endsWith("\\")) {
                string2 = string2 + "/";
            }
            string2 = string2 + "qtjambi.jar";
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{new URL("file:" + string2)});
            Class<?> clazz = uRLClassLoader.loadClass("com.trolltech.qt.Utilities");
            Field field = clazz.getDeclaredField("VERSION_STRING");
            String string3 = (String)field.get(null);
            if (QtJambiPlugin.incompatibleVersion(string3, JAMBI_MINIMUM_VERSION)) {
                MessageBox messageBox = new MessageBox(shell.getShell(), 33);
                messageBox.setMessage("You are currently using version " + string3 + " of Qt Jambi.\n" + "Your Qt Jambi Eclipse Integration is unfortunately only compatible with " + JAMBI_MINIMUM_VERSION + " and later.");
                messageBox.open();
                return false;
            }
            if (QtJambiPlugin.newMinorVersion(string3, JAMBI_MINIMUM_VERSION)) {
                MessageBox messageBox = new MessageBox(shell.getShell(), 196);
                messageBox.setMessage("You are currently using version " + string3 + " of Qt Jambi.\n" + "Your Qt Jambi Eclipse Integration is designed for version " + JAMBI_MINIMUM_VERSION + ".\n" + "For optimal performance, please consider upgrading your Qt Jambi Eclipse Integration at http://www.trolltech.com.\n\n" + "Do you wish to continue loading the Qt Jambi Eclipse Integration?");
                if (messageBox.open() == 128) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            MessageBox messageBox = new MessageBox(shell.getShell(), 33);
            messageBox.setMessage("The Qt Jambi Eclipse Integration has failed to load qtjambi.jar in " + string + ". Please set path to Jambi in preferences.");
            messageBox.open();
            return false;
        }
        return true;
    }
}

