/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qtjambi.wizards.pages;

import com.trolltech.qtjambi.QtJambiConnection;
import com.trolltech.qtjambi.wizards.pages.QtProjectWizardPage;
import com.trolltech.qtjambi.wizards.pages.QtWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class QtJavaProjectWizardPage
extends NewJavaProjectWizardPage
implements QtWizardPage {
    private IJavaProject javaProject;
    private QtProjectWizardPage projectPage;

    public QtJavaProjectWizardPage(IWorkspaceRoot iWorkspaceRoot, QtProjectWizardPage qtProjectWizardPage) {
        super(iWorkspaceRoot, (WizardNewProjectCreationPage)qtProjectWizardPage);
        this.projectPage = qtProjectWizardPage;
    }

    public void after(IProgressMonitor iProgressMonitor) {
        try {
            IProject iProject = this.projectPage.getProject();
            IProjectDescription iProjectDescription = iProject.getDescription();
            iProjectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            iProject.setDescription(iProjectDescription, iProgressMonitor);
            this.javaProject = this.getNewJavaProject();
            IClasspathEntry[] iClasspathEntryArray = this.getRawClassPath();
            for (int i = 0; i < iClasspathEntryArray.length; ++i) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[i];
                if (iClasspathEntry.getEntryKind() != 3) continue;
                ContainerGenerator containerGenerator = new ContainerGenerator(iClasspathEntry.getPath());
                containerGenerator.generateContainer(iProgressMonitor);
            }
            this.javaProject.setRawClasspath(new IClasspathEntry[0], true, iProgressMonitor);
            this.javaProject.setRawClasspath(this.getRawClassPath(), true, iProgressMonitor);
            this.javaProject.setOutputLocation(this.getOutputLocation(), iProgressMonitor);
        }
        catch (JavaModelException javaModelException) {
            QtJambiConnection.reportError((Exception)((Object)javaModelException), "Couldn't create project");
        }
        catch (CoreException coreException) {
            QtJambiConnection.reportError((Exception)((Object)coreException), "Couldn't create project");
        }
    }

    public void before(IProgressMonitor iProgressMonitor) {
    }

    public void current(IProgressMonitor iProgressMonitor) {
        IPath iPath;
        IClasspathAttribute[] iClasspathAttributeArray;
        IProject iProject = this.projectPage.getProject();
        String string = "lib";
        String string2 = Platform.getOS();
        if (string2.equals("win32")) {
            string = "bin";
        }
        String string3 = "JAMBI_LOCATION";
        String string4 = "";
        String string5 = "";
        IPath iPath2 = JavaCore.getClasspathVariable((String)string3);
        if (iPath2 != null) {
            string4 = iPath2.append(string).toString();
            string5 = iPath2.append("doc").append("html").toString();
        }
        Path path = new Path(string3 + '/' + "qtjambi.jar");
        IClasspathAttribute iClasspathAttribute = JavaCore.newClasspathAttribute((String)"org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", (String)string4);
        IClasspathAttribute iClasspathAttribute2 = JavaCore.newClasspathAttribute((String)"javadoc_location", (String)("file:" + string5));
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        if (iPreferenceStore.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects")) {
            iClasspathAttributeArray = iPreferenceStore.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName");
            iPath = iProject.getProject().getFullPath().append((String)iClasspathAttributeArray);
        } else {
            iPath = iProject.getProject().getFullPath();
        }
        iClasspathAttributeArray = new IClasspathAttribute[]{iClasspathAttribute, iClasspathAttribute2};
        IClasspathEntry iClasspathEntry = JavaCore.newVariableEntry((IPath)path, null, null, null, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)false);
        IClasspathEntry iClasspathEntry2 = JavaCore.newSourceEntry((IPath)iPath);
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[]{iClasspathEntry, iClasspathEntry2};
        this.setDefaultClassPath(iClasspathEntryArray, true);
        this.initBuildPaths();
    }
}

