/****************************************************************************
**
** Copyright (C) 2007-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QtGui>
#include <QtUiTools>
#include <QtXmlPatterns>

#include "querymainwindow.h"

QueryMainWindow::QueryMainWindow()
{
    queryWidget = loadUiFile();

    ui_inputTextEdit = qFindChild<QTextEdit*>(this, "inputTextEdit");
    ui_outputTextEdit = qFindChild<QTextEdit*>(this, "outputTextEdit");
    ui_queryTextEdit = qFindChild<QTextEdit*>(this, "queryTextEdit");

    ui_defaultQueries = qFindChild<QComboBox*>(this, "defaultQueries");

    QMetaObject::connectSlotsByName(this);

    connect(ui_defaultQueries, SIGNAL(currentIndexChanged(int)),
        this, SLOT(displayQuery(int)));

    inputFile.setFileName(":/files/cookbook.xml");
    loadInputFile();
    setCentralWidget(queryWidget);
    queryWidget->show();

    setWindowTitle(tr("Recipes XQuery Example"));

    const QStringList queries(QDir(":/files/", "*.xq").entryList());
    int len = queries.count();

    for(int i = 0; i < len; ++i)
        ui_defaultQueries->addItem(queries.at(i));
}

QWidget* QueryMainWindow::loadUiFile()
{
    QUiLoader loader;
    QFile file(":/forms/querywidget.ui");
    file.open(QFile::ReadOnly);

    QWidget *formWidget = loader.load(&file, this);
    file.close();

    return formWidget;
}

QSize QueryMainWindow::sizeHint() const
{
    return QSize(700, 430);
}

void QueryMainWindow::displayQuery(int index)
{
    QFile queryFile(QString(":files/") + ui_defaultQueries->itemText(index));
    queryFile.open(QIODevice::ReadOnly);

    const QString query(QString::fromLatin1(queryFile.readAll()));

    ui_queryTextEdit->setPlainText(query);

    evaluate(query);
}

void QueryMainWindow::loadInputFile()
{
    if (!inputFile.open(QIODevice::ReadOnly)) {
        QMessageBox::information(this,
            tr("Unable to open file"), inputFile.errorString());
        return;
    }

    QTextStream in(&inputFile);
    QString inputDocument = in.readAll();
    ui_inputTextEdit->setPlainText(inputDocument);
}

void QueryMainWindow::evaluate(const QString &str)
{
    /* This function takes the input string and displays the
     * appropriate output using QXmlQuery.
     */
    QXmlQuery query;
    query.setQuery(str);

    /* Since loadInputFile() reads the device to the very end, we will not get
     * anything if we try to read from it. Therefore we need to call QIODevice::reset(),
     * such that it is "rewinded". */
    inputFile.reset();

    Q_ASSERT(inputFile.isOpen());

    query.bindVariable("inputDocument", &inputFile);

    if(!query.isValid())
        qFatal("The query is invalid");

    QByteArray outArray;
    QBuffer buffer(&outArray);
    buffer.open(QIODevice::ReadWrite);
    
    QXmlFormatterPointer formatter(new QXmlFormatter(query, &buffer));

    if(!query.evaluateToReceiver(formatter))
        qFatal("A runtime error occurred while executing the query.");
 
    buffer.close();
    ui_outputTextEdit->setPlainText(QString::fromUtf8(outArray.constData()));
    
}
