/****************************************************************************
**
** Copyright (C) 2007-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QtCore/QCoreApplication>
#include <QtCore/QFile>
#include <QtCore/QLibraryInfo>
#include <QtCore/QStringList>
#include <QtCore/QTextStream>
#include <QtXmlPatterns/QXmlNamePool>
#include <QtXmlPatterns/QXmlQuery>
#include <QtXmlPatterns/QXmlSerializer>

#include "filetree.h"

int main(int argc, char **argv)
{
    enum {
        WrongArguments = 1,
        FileError,
        InvalidQuery
    };

    QCoreApplication app(argc, argv);

    if (app.arguments().count() < 2) {
        QTextStream(stderr) << "No query file or directory provided." << endl
                            << "filetree file.xq dir_path" << endl;
        return WrongArguments;
    }

    if (app.arguments().count() > 3) {
        QTextStream(stderr) << "Too many arguments." << endl
                            << "filetree file.xq dir_path" << endl;
        return WrongArguments;
    }

    QFile file(app.arguments().at(1));

    if (!file.open(QIODevice::ReadOnly)) {
        QTextStream(stderr) << "Failed to open " << file.fileName() << endl;
        return FileError;
    }

    QXmlQuery query;
    FileTree fileTree(query.namePool());
    query.setQuery(&file, QUrl::fromLocalFile(file.fileName()));

    QString dir;

    if (app.arguments().count() == 2)
        dir = QLibraryInfo::location(QLibraryInfo::ExamplesPath);
    else
        dir = app.arguments().at(2);

    query.bindVariable(QLatin1String("exampleDirectory"),fileTree.nodeFor(dir));

    if(!query.isValid())
        return InvalidQuery;

    QFile out;
    out.open(stdout, QIODevice::WriteOnly);

    QXmlSerializerPointer serializer(new QXmlSerializer(query, &out));
    query.evaluateToReceiver(serializer);

    return 0;
}
