/****************************************************************************
**
** Copyright (C) 2007-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "webview.h"
#include "browsermainwindow.h"
#include <QAction>

WebView::WebView(BrowserMainWindow *mainWindow, QWidget* parent)
    : QWebView(parent)
    , m_loadingFinished(true)
    , m_mainWindow(mainWindow)
{
    connect(page(), SIGNAL(statusBarMessage(const QString&)),
            SLOT(slotStatusBarText(const QString&)));
    connect(page()->networkAccessManager(), SIGNAL(authenticationRequired(QNetworkReply*, QAuthenticator*)),
            SLOT(slotAuthenticationRequired(QNetworkReply*,QAuthenticator*)));
    connect(page()->networkAccessManager(), SIGNAL(proxyAuthenticationRequired(const QNetworkProxy&, QAuthenticator*)),
            SLOT(slotProxyAuthenticationRequired(const QNetworkProxy&, QAuthenticator*)));
    connect(page()->networkAccessManager(), SIGNAL(sslErrors(QNetworkReply*, const QList<QSslError>&)),
            SLOT(slotSslErrors(QNetworkReply*, const QList<QSslError>&)));

    connect(this, SIGNAL(loadStarted()), SLOT(slotLoadStarted()));
    connect(this, SIGNAL(loadFinished()),SLOT(slotLoadFinished()));

    pageAction(QWebPage::Back)->setShortcut(Qt::AltModifier + Qt::Key_Left);
    pageAction(QWebPage::Forward)->setShortcut(Qt::AltModifier + Qt::Key_Right);
}

void WebView::loadUrl(const QUrl& url)
{
    m_initialUrl = url;
    load(url);
}

QString WebView::lastStausBarText() const
{
    return m_statusBarText;
}

bool WebView::loadIsFinished() const
{
    return m_loadingFinished;
}

QUrl WebView::url() const
{
    QUrl url = QWebView::url();
    if (!url.isEmpty())
        return url;

    return m_initialUrl;
}

QWebView *WebView::createWindow(QWebPage::WebWindowType)
{
    return m_mainWindow->createTab();
}

void WebView::slotStatusBarText(const QString& txt)
{
    m_statusBarText = txt;
}

void WebView::slotLoadStarted()
{
    m_loadingFinished = false;
}

void WebView::slotLoadFinished()
{
    m_loadingFinished = true;
}

void WebView::slotAuthenticationRequired(QNetworkReply* reply, QAuthenticator* auth)
{
    emit authenticationRequired(this, reply, auth);
}

void WebView::slotProxyAuthenticationRequired(const QNetworkProxy& proxy, QAuthenticator* auth)
{
    emit proxyAuthenticationRequired(this, proxy, auth);
}

void WebView::slotSslErrors(QNetworkReply* replay, const QList<QSslError>& error)
{
    emit sslErrors(this, replay, error);
}
