/****************************************************************************
**
** Copyright (C) 2007-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef BROWSERMAINWINDOW_H
#define BROWSERMAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QtGui/QIcon>
#include <QtCore/QUrl>

QT_BEGIN_NAMESPACE
class QAuthenticator;
class QLineEdit;
class QNetworkProxy;
class QNetworkReply;
class QSslError;
class QTabWidget;
QT_END_NAMESPACE

class WebView;
class BrowserTabProxy;
class ChaseWidget;
class ToolbarSearch;
class CookieJar;
class History;
class AutoSave;
class DownloadManager;

/**
 * @short The MainWindow of the Browser Application.
 *
 * This is keeping track of the menu, window title, creating and
 * closing tabs.
 */
class BrowserMainWindow : public QMainWindow {
    Q_OBJECT

public:
    BrowserMainWindow();
    ~BrowserMainWindow();

public:
    static QUrl guessUrlFromString(const QString &);

    WebView *createTab();

    void loadPage(const QString &);

    QString currentPage() const;

private slots:
    void slotHandleUnsupportedContent(QNetworkReply *reply);
    void save();
    void restore();
    void restoreLastSession();

    void slotLoadUrl(const QUrl &url);
    void slotSearch(const QUrl &url);

    void slotNewTab();
    void slotCloseTab(int);
    void slotPreferences();

    void slotUpdateStatusbar(const QString &);
    void slotUpdateWindowTitle(const QString &);

    void slotCurrentTabChanged(int);

    void slotNewWindow();
    void slotOpenFile();
    void slotCloseTab();
    void slotUndo();
    void slotRedo();
    void slotCut();
    void slotCopy();
    void slotPaste();
    void slotStop();
    void slotReload();
    void slotTextBigger();
    void slotTextNormal();
    void slotTextSmaller();
    void slotToggleFullScreen(bool enable);
    void slotPageSource();
    void slotBack();
    void slotForward();
    void slotHome();
    void slotWebSearch();
    void slotToggleInspector(bool enable);
    void slotToggleToolbar();
    void slotToggleStatusbar();
    void slotAboutApplication();
    void slotUrlEntered();
    void slotAboutToShowRecentTabs();
    void slotAboutToShowRecentTriggered(QAction *action);

    void slotLoadStarted();
    void slotLoadFinished();
    void slotUrlChanged(const QUrl &url);

    void slotWebViewTitleChanged(const QString &);
    void slotWebViewIconChanged();
    void slotDownloadManager();

    void slotNextTab();
    void slotPreviousTab();

    void slotAuthenticationRequired(WebView*, QNetworkReply*, QAuthenticator*);
    void slotProxyAuthenticationRequired(WebView*, const QNetworkProxy&, QAuthenticator*);
    void slotSslErrors(WebView*, QNetworkReply*, const QList<QSslError>& error);

private:
    void setupMenu();
    void setupToolBar();
    void setCurrentTab(WebView *tab);
    void replaceCurrentUrl(const QUrl &);
    WebView *currentTab() const;

    void updateStatusbarActionText(bool visible);
    void updateToolbarActionText(bool visible);

private:
    QToolBar *navigationBar;
    QTabWidget *m_mainTabWidget;
    ToolbarSearch *m_toolbarSearch;
    QLineEdit *m_urlEdit;
    ChaseWidget *m_chaseWidget;
    CookieJar *m_cookieJar;
    History *m_history;
    QMenu *m_recentlyClosedTabsMenu;
    AutoSave *m_autoSave;
    DownloadManager *m_downloadManager;

    QAction *m_historyBack;
    QAction *m_historyForward;
    QAction *m_stop;
    QAction *m_reload;
    QAction *m_stopReload;
    QAction *m_cut;
    QAction *m_copy;
    QAction *m_paste;
    QAction *m_undo;
    QAction *m_redo;
    QAction *m_viewToolbar;
    QAction *m_viewStatusbar;
    QAction *m_newTab;
    QAction *m_closeTab;
    QAction *m_downloads;
    QAction *m_textBigger;
    QAction *m_textNormal;
    QAction *m_textSmaller;
    QAction *m_nextTab;
    QAction *m_previousTab;
    QAction *m_recentlyClosedTabsAction;
    QAction *m_restoreLastSession;

    QIcon m_reloadIcon;
    QIcon m_stopIcon;

    friend class BrowserTabProxy;
    BrowserTabProxy *m_proxy;

    static const int LastClosedUrlsSize = 10;
    QList<QUrl> m_recentlyClosedUrls;
};

#endif // BROWSERMAINWINDOW_H
