#ifndef QT_LUPDATE_H
#define QT_LUPDATE_H

#include "metatranslator.h"
#include "qconsole.h"

#include <QCoreApplication>
#include <QString>
#include <QDir>

QT_BEGIN_NAMESPACE

class QByteArray;
class QString;
class QStringList;

class LupdateApplication : public QCoreApplication
{
    Q_OBJECT
public:
    LupdateApplication(int &argc, char **argv);

    int start();

    // defined in fetchtr.cpp
    void fetchtr_cpp( const QString &fileName, MetaTranslator *tor,
                      const QString &defaultContext, bool mustExist,
                      const QByteArray &codecForSource );
    void fetchtr_ui( const QString &fileName, MetaTranslator *tor,
                     const QString &defaultContext, bool mustExist );

    // defined in fetchtrjava.cpp
    void fetchtr_java( const QString &fileName, MetaTranslator *tor,
                       const QString &defaultContext, bool mustExist,
                       const QByteArray &codecForSource );
    // defined in merge.cpp
    void merge( const MetaTranslator *tor, const MetaTranslator *virginTor,
                MetaTranslator *out, bool verbose, bool noObsolete );

    void recursiveFileInfoList( const QDir &dir, const QStringList &nameFilters, 
                                QDir::Filters filter, bool recursive, QFileInfoList *fileinfolist);
    void printUsage();
    void updateTsFiles( const MetaTranslator& fetchedTor,
                               const QStringList& tsFileNames, const QString& codecForTr,
                               bool noObsolete, bool pluralOnly, bool verbose );

private:
    QString m_defaultExtensions;
};

QT_END_NAMESPACE

#endif // QT_LUPDATE_H
