/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qnamepool_p.h"
#include "qxmlnamepool.h"

QT_BEGIN_NAMESPACE

/*!
  \class QXmlNamePool
  \brief The QXmlNamePool class is a pool of XML names.
  \reentrant
  \since 4.4
  \ingroup xml-tools

  Together with QXmlName, QXmlNamePool is a strong optimization for dealing with XML names, which
  typically are encounted in vast quantities. QXmlName is essentially a place holder for a name
  that can quickly be compared and passed around, while QXmlNamePool contains the actual strings
  associated with a name. By constructing a QXmlName and passing in the strings and the pool
  to use, one get a swift QXmlName in return.

  A QXmlName instance is tied to the name pool it was created with. For instance, if one name
  is created with one name pool, and then compare to a name from another name pool, the result
  is undefined. A QXmlName is only valid for the name pool it was created with.

  QXmlName represent what often are called an "expanded QName", or simply QName.

  \sa QXmlName
  \sa QXmlQuery::namePool()
 */

/*!
  Constructs an invalid query that cannot be used. setQuery() must be called.
 */
QXmlNamePool::QXmlNamePool() : d(new QPatternist::NamePool())
{
}

/*!
  Constructs a QXmlNamePool instance that is a copy of \a other.
 */
QXmlNamePool::QXmlNamePool(const QXmlNamePool &other) : d(other.d)
{
}

/*!
  Destructs this QXmlNamePool instance.
 */
QXmlNamePool::~QXmlNamePool()
{
}

/*!
  Assigns \a other to this QXmlNamePool instance.
 */
QXmlNamePool &QXmlNamePool::operator=(const QXmlNamePool &other)
{
    d = other.d;
    return *this;
}

QT_END_NAMESPACE

