/****************************************************************************
**
** Copyright (C) 2006-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the QtXMLPatterns module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef Patternist_AccelTreeResourceLoader_H
#define Patternist_AccelTreeResourceLoader_H

#include <QtCore/QHash>
#include <QtCore/QEventLoop>
#include <QtNetwork/QNetworkReply>

#include "qacceltree_p.h"
#include "qnamepool_p.h"
#include "qresourceloader_p.h"
#include "qabstractxmlreceiver.h"

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

class QIODevice;

namespace QPatternist
{
    class NetworkLoop : public QEventLoop
    {
        Q_OBJECT

    public Q_SLOTS:
        void error(QNetworkReply::NetworkError code)
        {
            Q_UNUSED(code);
            exit(1);
        }

        void finished()
        {
            exit(0);
        }
    };

    /**
     * @short Handles requests for documents, and instantiates
     * them as AccelTree instances.
     *
     * @author Frans Englich <fenglich@trolltech.com>
     */
    class Q_AUTOTEST_EXPORT AccelTreeResourceLoader : public ResourceLoader
    {
    public:
        /**
         * AccelTreeResourceLoader does not own @p networkManager.
         */
        AccelTreeResourceLoader(const NamePool::Ptr &np,
                                QNetworkAccessManager *const networkManager);

        virtual Item openDocument(const QUrl &uri);
        virtual SequenceType::Ptr announceDocument(const QUrl &uri, const Usage usageHint);
        virtual bool isDocumentAvailable(const QUrl &uri);

        /**
         * Helper function that basically do QNetworkAccessManager::get(), but
         * does it blocked.
         *
         * The return QNetworkReply has emitted QNetworkReply::finished().
         *
         * The caller owns the return QIODevice instance.
         *
         * Returns @c null if a failure occurred.
         */
        static QNetworkReply *load(const QUrl &uri,
                                   QNetworkAccessManager *const networkManager);

    private:
        static bool streamToReceiver(QIODevice *const dev,
                                     const QAbstractXmlReceiver::Ptr &receiver,
                                     const NamePool::Ptr &np);
        bool retrieveDocument(const QUrl &uri);
        static inline QString prefixFromQXmlName(const QString &qName);

        QHash<QUrl, AccelTree::Ptr>     m_loadedDocuments;
        const NamePool::Ptr             m_namePool;
        QNetworkAccessManager *const    m_networkAccessManager;
    };
}

QT_END_NAMESPACE

QT_END_HEADER

#endif
