/****************************************************************************
**
** Copyright (C) 2005-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

// Generated code, do not edit! Use generator at tools/qtconcurrent/generatecreatefunctor/
#ifndef QTCONCURRENT_CREATEFUNCTOR_H
#define QTCONCURRENT_CREATEFUNCTOR_H

#include <QtCore/qglobal.h>

#ifndef QT_NO_CONCURRENT

#include <QtCore/qtconcurrentcompilertest.h>
#include <QtCore/qtconcurrentrunbase.h>

QT_BEGIN_HEADER
QT_BEGIN_NAMESPACE

QT_MODULE(Core)

namespace QtConcurrent {

template <typename T, typename FunctionPointer>
struct Functor0
{
    typedef T result_type;
    inline Functor0(FunctionPointer function)
      : function(function) {}
    inline T operator()() { return function(); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer>
struct VoidFunctor0
{
    typedef T result_type;
    inline VoidFunctor0(FunctionPointer function)
      : function(function) {}
    inline void operator()() { function(); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer>
struct SelectFunctor0
{
    typedef typename SelectSpecialization<T>::template
        Type<Functor0    <T, FunctionPointer>,
             VoidFunctor0<T, FunctionPointer> >::type type;
};

template <typename T>
inline typename SelectFunctor0<T, T(*)()>::type createFunctor(T (*fn)())
{
    return QT_TYPENAME SelectFunctor0<T, T(*)()>::type(fn);
}

template <typename T, typename Class>
struct MemberFunctor0
{
    typedef T result_type;
    inline MemberFunctor0(Class *object, T (Class::*fn)())
      : object(object), fn(fn) {}
    inline T operator()() { return (object->*fn)(); };
    Class *object;
    T (Class::*fn)();
};

template <typename T, typename Class>
struct VoidMemberFunctor0
{
    typedef T result_type;
    inline VoidMemberFunctor0(Class *object, T (Class::*fn)())
      : object(object), fn(fn) {}
    inline void operator()() { (object->*fn)(); };
    Class *object;
    T (Class::*fn)();
};

template <typename T, typename Class>
struct SelectMemberFunctor0
{
    typedef typename SelectSpecialization<T>::template
        Type<MemberFunctor0    <T, Class>,
             VoidMemberFunctor0<T, Class> >::type type;
};

template <typename T, typename Class>
inline typename SelectMemberFunctor0<T, Class>::type createFunctor(Class *object, T (Class::*fn)())
{
    return QT_TYPENAME SelectMemberFunctor0<T, Class>::type(object, fn);
}
template <typename T, typename FunctionPointer, typename Arg1>
struct Functor1
{
    typedef T result_type;
    inline Functor1(FunctionPointer function)
      : function(function) {}
    inline T operator()(const Arg1 &arg1) { return function(arg1); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer, typename Arg1>
struct VoidFunctor1
{
    typedef T result_type;
    inline VoidFunctor1(FunctionPointer function)
      : function(function) {}
    inline void operator()(const Arg1 &arg1) { function(arg1); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer, typename Arg1>
struct SelectFunctor1
{
    typedef typename SelectSpecialization<T>::template
        Type<Functor1    <T, FunctionPointer, Arg1>,
             VoidFunctor1<T, FunctionPointer, Arg1> >::type type;
};

template <typename T, typename Arg1>
inline typename SelectFunctor1<T, T(*)(Arg1), Arg1>::type createFunctor(T (*fn)(Arg1))
{
    return QT_TYPENAME SelectFunctor1<T, T(*)(Arg1), Arg1>::type(fn);
}

template <typename T, typename Class, typename Arg1>
struct MemberFunctor1
{
    typedef T result_type;
    inline MemberFunctor1(Class *object, T (Class::*fn)(Arg1))
      : object(object), fn(fn) {}
    inline T operator()(const Arg1 &arg1) { return (object->*fn)(arg1); };
    Class *object;
    T (Class::*fn)(Arg1);
};

template <typename T, typename Class, typename Arg1>
struct VoidMemberFunctor1
{
    typedef T result_type;
    inline VoidMemberFunctor1(Class *object, T (Class::*fn)(Arg1))
      : object(object), fn(fn) {}
    inline void operator()(const Arg1 &arg1) { (object->*fn)(arg1); };
    Class *object;
    T (Class::*fn)(Arg1);
};

template <typename T, typename Class, typename Arg1>
struct SelectMemberFunctor1
{
    typedef typename SelectSpecialization<T>::template
        Type<MemberFunctor1    <T, Class, Arg1>,
             VoidMemberFunctor1<T, Class, Arg1> >::type type;
};

template <typename T, typename Class, typename Arg1>
inline typename SelectMemberFunctor1<T, Class, Arg1>::type createFunctor(Class *object, T (Class::*fn)(Arg1))
{
    return QT_TYPENAME SelectMemberFunctor1<T, Class, Arg1>::type(object, fn);
}
template <typename T, typename FunctionPointer, typename Arg1, typename Arg2>
struct Functor2
{
    typedef T result_type;
    inline Functor2(FunctionPointer function)
      : function(function) {}
    inline T operator()(const Arg1 &arg1, const Arg2 &arg2) { return function(arg1, arg2); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2>
struct VoidFunctor2
{
    typedef T result_type;
    inline VoidFunctor2(FunctionPointer function)
      : function(function) {}
    inline void operator()(const Arg1 &arg1, const Arg2 &arg2) { function(arg1, arg2); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2>
struct SelectFunctor2
{
    typedef typename SelectSpecialization<T>::template
        Type<Functor2    <T, FunctionPointer, Arg1, Arg2>,
             VoidFunctor2<T, FunctionPointer, Arg1, Arg2> >::type type;
};

template <typename T, typename Arg1, typename Arg2>
inline typename SelectFunctor2<T, T(*)(Arg1, Arg2), Arg1, Arg2>::type createFunctor(T (*fn)(Arg1, Arg2))
{
    return QT_TYPENAME SelectFunctor2<T, T(*)(Arg1, Arg2), Arg1, Arg2>::type(fn);
}

template <typename T, typename Class, typename Arg1, typename Arg2>
struct MemberFunctor2
{
    typedef T result_type;
    inline MemberFunctor2(Class *object, T (Class::*fn)(Arg1, Arg2))
      : object(object), fn(fn) {}
    inline T operator()(const Arg1 &arg1, const Arg2 &arg2) { return (object->*fn)(arg1, arg2); };
    Class *object;
    T (Class::*fn)(Arg1, Arg2);
};

template <typename T, typename Class, typename Arg1, typename Arg2>
struct VoidMemberFunctor2
{
    typedef T result_type;
    inline VoidMemberFunctor2(Class *object, T (Class::*fn)(Arg1, Arg2))
      : object(object), fn(fn) {}
    inline void operator()(const Arg1 &arg1, const Arg2 &arg2) { (object->*fn)(arg1, arg2); };
    Class *object;
    T (Class::*fn)(Arg1, Arg2);
};

template <typename T, typename Class, typename Arg1, typename Arg2>
struct SelectMemberFunctor2
{
    typedef typename SelectSpecialization<T>::template
        Type<MemberFunctor2    <T, Class, Arg1, Arg2>,
             VoidMemberFunctor2<T, Class, Arg1, Arg2> >::type type;
};

template <typename T, typename Class, typename Arg1, typename Arg2>
inline typename SelectMemberFunctor2<T, Class, Arg1, Arg2>::type createFunctor(Class *object, T (Class::*fn)(Arg1, Arg2))
{
    return QT_TYPENAME SelectMemberFunctor2<T, Class, Arg1, Arg2>::type(object, fn);
}
template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3>
struct Functor3
{
    typedef T result_type;
    inline Functor3(FunctionPointer function)
      : function(function) {}
    inline T operator()(const Arg1 &arg1, const Arg2 &arg2, const Arg3 &arg3) { return function(arg1, arg2, arg3); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3>
struct VoidFunctor3
{
    typedef T result_type;
    inline VoidFunctor3(FunctionPointer function)
      : function(function) {}
    inline void operator()(const Arg1 &arg1, const Arg2 &arg2, const Arg3 &arg3) { function(arg1, arg2, arg3); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3>
struct SelectFunctor3
{
    typedef typename SelectSpecialization<T>::template
        Type<Functor3    <T, FunctionPointer, Arg1, Arg2, Arg3>,
             VoidFunctor3<T, FunctionPointer, Arg1, Arg2, Arg3> >::type type;
};

template <typename T, typename Arg1, typename Arg2, typename Arg3>
inline typename SelectFunctor3<T, T(*)(Arg1, Arg2, Arg3), Arg1, Arg2, Arg3>::type createFunctor(T (*fn)(Arg1, Arg2, Arg3))
{
    return QT_TYPENAME SelectFunctor3<T, T(*)(Arg1, Arg2, Arg3), Arg1, Arg2, Arg3>::type(fn);
}

template <typename T, typename Class, typename Arg1, typename Arg2, typename Arg3>
struct MemberFunctor3
{
    typedef T result_type;
    inline MemberFunctor3(Class *object, T (Class::*fn)(Arg1, Arg2, Arg3))
      : object(object), fn(fn) {}
    inline T operator()(const Arg1 &arg1, const Arg2 &arg2, const Arg3 &arg3) { return (object->*fn)(arg1, arg2, arg3); };
    Class *object;
    T (Class::*fn)(Arg1, Arg2, Arg3);
};

template <typename T, typename Class, typename Arg1, typename Arg2, typename Arg3>
struct VoidMemberFunctor3
{
    typedef T result_type;
    inline VoidMemberFunctor3(Class *object, T (Class::*fn)(Arg1, Arg2, Arg3))
      : object(object), fn(fn) {}
    inline void operator()(const Arg1 &arg1, const Arg2 &arg2, const Arg3 &arg3) { (object->*fn)(arg1, arg2, arg3); };
    Class *object;
    T (Class::*fn)(Arg1, Arg2, Arg3);
};

template <typename T, typename Class, typename Arg1, typename Arg2, typename Arg3>
struct SelectMemberFunctor3
{
    typedef typename SelectSpecialization<T>::template
        Type<MemberFunctor3    <T, Class, Arg1, Arg2, Arg3>,
             VoidMemberFunctor3<T, Class, Arg1, Arg2, Arg3> >::type type;
};

template <typename T, typename Class, typename Arg1, typename Arg2, typename Arg3>
inline typename SelectMemberFunctor3<T, Class, Arg1, Arg2, Arg3>::type createFunctor(Class *object, T (Class::*fn)(Arg1, Arg2, Arg3))
{
    return QT_TYPENAME SelectMemberFunctor3<T, Class, Arg1, Arg2, Arg3>::type(object, fn);
}
template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct Functor4
{
    typedef T result_type;
    inline Functor4(FunctionPointer function)
      : function(function) {}
    inline T operator()(const Arg1 &arg1, const Arg2 &arg2, const Arg3 &arg3, const Arg4 &arg4) { return function(arg1, arg2, arg3, arg4); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct VoidFunctor4
{
    typedef T result_type;
    inline VoidFunctor4(FunctionPointer function)
      : function(function) {}
    inline void operator()(const Arg1 &arg1, const Arg2 &arg2, const Arg3 &arg3, const Arg4 &arg4) { function(arg1, arg2, arg3, arg4); }
    FunctionPointer function;
};

template <typename T, typename FunctionPointer, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct SelectFunctor4
{
    typedef typename SelectSpecialization<T>::template
        Type<Functor4    <T, FunctionPointer, Arg1, Arg2, Arg3, Arg4>,
             VoidFunctor4<T, FunctionPointer, Arg1, Arg2, Arg3, Arg4> >::type type;
};

template <typename T, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
inline typename SelectFunctor4<T, T(*)(Arg1, Arg2, Arg3, Arg4), Arg1, Arg2, Arg3, Arg4>::type createFunctor(T (*fn)(Arg1, Arg2, Arg3, Arg4))
{
    return QT_TYPENAME SelectFunctor4<T, T(*)(Arg1, Arg2, Arg3, Arg4), Arg1, Arg2, Arg3, Arg4>::type(fn);
}

template <typename T, typename Class, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct MemberFunctor4
{
    typedef T result_type;
    inline MemberFunctor4(Class *object, T (Class::*fn)(Arg1, Arg2, Arg3, Arg4))
      : object(object), fn(fn) {}
    inline T operator()(const Arg1 &arg1, const Arg2 &arg2, const Arg3 &arg3, const Arg4 &arg4) { return (object->*fn)(arg1, arg2, arg3, arg4); };
    Class *object;
    T (Class::*fn)(Arg1, Arg2, Arg3, Arg4);
};

template <typename T, typename Class, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct VoidMemberFunctor4
{
    typedef T result_type;
    inline VoidMemberFunctor4(Class *object, T (Class::*fn)(Arg1, Arg2, Arg3, Arg4))
      : object(object), fn(fn) {}
    inline void operator()(const Arg1 &arg1, const Arg2 &arg2, const Arg3 &arg3, const Arg4 &arg4) { (object->*fn)(arg1, arg2, arg3, arg4); };
    Class *object;
    T (Class::*fn)(Arg1, Arg2, Arg3, Arg4);
};

template <typename T, typename Class, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
struct SelectMemberFunctor4
{
    typedef typename SelectSpecialization<T>::template
        Type<MemberFunctor4    <T, Class, Arg1, Arg2, Arg3, Arg4>,
             VoidMemberFunctor4<T, Class, Arg1, Arg2, Arg3, Arg4> >::type type;
};

template <typename T, typename Class, typename Arg1, typename Arg2, typename Arg3, typename Arg4>
inline typename SelectMemberFunctor4<T, Class, Arg1, Arg2, Arg3, Arg4>::type createFunctor(Class *object, T (Class::*fn)(Arg1, Arg2, Arg3, Arg4))
{
    return QT_TYPENAME SelectMemberFunctor4<T, Class, Arg1, Arg2, Arg3, Arg4>::type(object, fn);
}
} //namespace QtConcurrent

QT_END_NAMESPACE
QT_END_HEADER

#endif // QT_NO_CONCURRENT

#endif
