/*  This file is part of the KDE project.

    Copyright (C) 2007 Trolltech ASA. All rights reserved.

    This library is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 2.1 or 3 of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef Phonon_Gstreamer_VOLUMEFADEREFFECT_H
#define Phonon_Gstreamer_VOLUMEFADEREFFECT_H

#include <QtCore>
#include <phonon/effectinterface.h>
#include <phonon/effectparameter.h>
#include <phonon/volumefaderinterface.h>
#include "medianode.h"

namespace Phonon
{
namespace Gstreamer
{

    class VolumeFaderEffect : public QObject, public MediaNode, public Phonon::EffectInterface, public Phonon::VolumeFaderInterface
    {
        Q_OBJECT
        Q_INTERFACES(Phonon::EffectInterface Phonon::VolumeFaderInterface Phonon::Gstreamer::MediaNode)

        public:
            VolumeFaderEffect(Backend *backend, QObject *parent = 0);
            ~VolumeFaderEffect();
            GstElement *audioElement() { return m_volume; }

            // EffectInterface:
            QList<Phonon::EffectParameter> parameters() const;
            QVariant parameterValue(const Phonon::EffectParameter &parameter) const;
            void setParameterValue(const Phonon::EffectParameter &parameter, const QVariant &newValue);

            // VolumeFaderInterface:
            float volume() const;
            void setVolume(float volume);
            Phonon::VolumeFaderEffect::FadeCurve fadeCurve() const;
            void setFadeCurve(Phonon::VolumeFaderEffect::FadeCurve fadeCurve);
            void fadeTo(float volume, int fadeTime);
            void updateFade();
            bool event(QEvent *);

            Phonon::VolumeFaderEffect::FadeCurve m_fadeCurve;
            int m_fadeTimer;
            int m_fadeDuration;
            float m_fadeFromVolume;
            float m_fadeToVolume;
            QTime m_fadeStartTime;
            GstElement *m_volume;
    };

}} //namespace Phonon::Gstreamer

#endif // Phonon_Gstreamer_VOLUMEFADEREFFECT_H
