/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "searchwidget.h"

#include <QtGui/QComboBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QLineEdit>

SearchWidget::SearchWidget(QWidget* parent)
    : QWidget(parent)
    , m_searchEngine(Search_Trolltech)
{
    setObjectName("SearchWidget");

    QHBoxLayout* lay = new QHBoxLayout(this);
    lay->setSpacing(0);

    m_searchEngineBox = new QComboBox(this);
    lay->addWidget(m_searchEngineBox);
    connect(m_searchEngineBox, SIGNAL(activated(int)), SLOT(slotSearchEngineChanged(int)));
    fillSearchBox();

    m_searchText = new QLineEdit(this);
    lay->addWidget(m_searchText);
    setFocusProxy(m_searchText);
    connect(m_searchText, SIGNAL(returnPressed()), SLOT(slotPrepareSearch()));
}

void SearchWidget::fillSearchBox()
{
    m_searchEngineBox->addItem(QIcon(":trolltech.png"), tr("Qt Documentation"), Search_Trolltech);
    m_searchEngineBox->addItem(QIcon(":google.png"),  tr("Google"), Search_Google);
    m_searchEngineBox->addItem(QIcon(":yahoo.png"),   tr("Yahoo"), Search_Yahoo);
    m_searchEngineBox->addItem(QIcon(":amazon.png"),  tr("Amazon"), Search_Amazon);
    m_searchEngineBox->addItem(QIcon(":answers.png"), tr("Answers"), Search_Answers);
    m_searchEngineBox->addItem(QIcon(":creativecommons.png"), tr("Creative Commons"), Search_CreativeCommons);
    m_searchEngineBox->addItem(QIcon(":ebay.png"), tr("Ebay"), Search_Ebay);
    m_searchEngineBox->addItem(QIcon(":wikipedia.png"), tr("Wikipedia"), Search_Wikipedia);
}

void SearchWidget::save()
{
}

void SearchWidget::restore()
{
}

void SearchWidget::slotPrepareSearch()
{
    QString searchText = m_searchText->text();
    m_searchText->clear();
    m_recentSearches.append(searchText);
    if (m_recentSearches.size() >= SearchWidget::SearchItems)
        m_recentSearches.resize(SearchWidget::SearchItems-1);

    emit search(createUrl(m_searchEngine, searchText));
}

void SearchWidget::slotSearchEngineChanged(int index)
{
    m_searchEngine = static_cast<QuickSearch>(m_searchEngineBox->itemData(index).toInt());
}

QUrl SearchWidget::createUrl(QuickSearch engine, const QString& _searchText)
{
    QString url;
    QString searchText = _searchText;

    switch (engine) {
    case Search_Trolltech:
        url = QLatin1String("http://www.google.com/search?q=\\{@}&ie=UTF-8&oe=UTF-8");
        searchText += QLatin1String(" site:doc.trolltech.com");
        break;
    case Search_Google:
        url = QLatin1String("http://www.google.com/search?q=\\{@}&ie=UTF-8&oe=UTF-8");
        break;
    case Search_Yahoo:
        url = QLatin1String("http://search.yahoo.com/search?p=\\{@}&ei=UTF-8");
        break;
    case Search_Amazon:
        url = QLatin1String("http://www.amazon.com/exec/obidos/external-search/?field-keywords=\\{@}&mode=blended");
        break;
    case Search_Answers:
        url = QLatin1String("http://www.answers.com/main/ntquery?s=\\{@}");
        break;
    case Search_CreativeCommons:
        url = QLatin1String("http://search.creativecommons.org?q=\\{@}");
        break;
    case Search_Ebay:
        url = QLatin1String("http://search.ebay.com/search/search.dll?query=\\{@}");
        break;
    case Search_Wikipedia:
        url = QLatin1String("http://wikipedia.org/wiki/\\{@}");
        break;
    case Search_Custom:
    default:
        Q_ASSERT(false);
        return QUrl();
    }

    return QUrl(url.replace("\\{@}", searchText));
}

void SearchWidget::selectAll()
{
    m_searchText->selectAll();
}
