/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.0, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** In addition, as a special exception, Trolltech, as the sole copyright
** holder for Qt Designer, grants users of the Qt/Eclipse Integration
** plug-in the right for the Qt/Eclipse Integration to link to
** functionality provided by Qt Designer and its related libraries.
**
** Trolltech reserves all rights not expressly granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef BROWSER_MAIN_WINDOW_H
#define BROWSER_MAIN_WINDOW_H

#include <QtGui/QMainWindow>
#include <QtCore/QUrl>

class QMovie;
class QLineEdit;
class QTabWidget;

class BrowserTab;
class SearchWidget;
class BrowserTabProxy;

/**
 * @short The MainWindow of the Browser Application.
 *
 * This is keeping track of the menu, window title, creating and
 * closing tabs.
 */
class BrowserMainWindow : public QMainWindow {
    Q_OBJECT

public:
    BrowserMainWindow();
    ~BrowserMainWindow();

public:
    static QUrl guessUrlFromString(const QString&);

    BrowserTab *createTab();

    void loadPage(const QString&);

private Q_SLOTS:
    void slotSearch(const QUrl&);

    void slotNewTab();
    void slotCloseTab(int);

    void slotUpdateStatusbar(const QString&);
    void slotUpdateWindowTitle(const QString&);

    void slotCurrentTabChanged(int);

    void slotNewWindow();
    void slotOpenFile();
    void slotCloseTab();
    void slotUndo();
    void slotRedo();
    void slotCut();
    void slotCopy();
    void slotPaste();
    void slotSelectAll();
    void slotFind();
    void slotFindNext();
    void slotSwitchTextDirection();
    void slotStop();
    void slotReload();
    void slotZoomIn();
    void slotZoomOut();
    void slotToggleFullScreen();
    void slotPageSource();
    void slotBack();
    void slotForward();
    void slotHome();
    void slotWebSearch();
    void slotShowDownloads();
    void slotShowErrorConsole();
    void slotToggleInspector(bool enable);
    void slotToggleToolbar();
    void slotToggleStatusbar();
    void slotAboutWebKit();
    void slotUrlEntered();

    void slotLoadStarted();
    void slotLoadFinished();
    void slotUrlChanged(const QUrl &url);

    void slotBrowserTabTitleChanged(const QString&);
    void slotBrowserTabIconChanged();

    void nextTab();
    void previousTab();

private:
    void setupMenu();
    void setupToolBar();
    void setCurrentTab(BrowserTab* tab);
    void replaceCurrentUrl(const QUrl&);
    BrowserTab* currentTab() const;

private:
    QToolBar* navigationBar;
    QTabWidget* m_mainTabWidget;
    SearchWidget* m_searchWidget;
    QLineEdit* m_urlEdit;
    QMovie* m_browserLogo;

    QAction* m_historyBack;
    QAction* m_historyForward;
    QAction* m_stop;
    QAction* m_reload;
    QAction* m_cut;
    QAction* m_copy;
    QAction* m_paste;
    QAction* m_undo;
    QAction* m_redo;
    QAction* m_fullScreen;
    QAction* m_viewToolbar;
    QAction* m_viewStatusbar;

    friend class BrowserTabProxy;
    BrowserTabProxy* m_proxy;


    static const int LastClosedUrlsSize = 10;
    QVector<QUrl> m_recentlyClosedUrls;
};

#endif
