/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the tools applications of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QDBUSEXTRATYPES_H
#define QDBUSEXTRATYPES_H

// define some useful types for D-BUS

#include <QtCore/qvariant.h>
#include <QtCore/qstring.h>
#include <QtDBus/qdbusmacros.h>

QT_BEGIN_HEADER

struct QDBUS_EXPORT QDBusObjectPath
{
    inline QDBusObjectPath() { }

    inline explicit QDBusObjectPath(const char *path)
        : value(QString::fromLatin1(path))
    { check(); }

    inline explicit QDBusObjectPath(const QLatin1String &path)
        : value(path)
    { check(); }

    inline explicit QDBusObjectPath(const QString &path)
        : value(path)
    { check(); }

    QString value;

private:
    void check();
};
Q_DECLARE_METATYPE(QDBusObjectPath)

struct QDBUS_EXPORT QDBusSignature
{
    inline QDBusSignature() { }

    inline explicit QDBusSignature(const char *signature)
        : value(QString::fromLatin1(signature))
    { check(); }

    inline explicit QDBusSignature(const QLatin1String &signature)
        : value(signature)
    { check(); }

    inline explicit QDBusSignature(const QString &signature)
        : value(signature)
    { check(); }

    QString value;

private:
    void check();
};
Q_DECLARE_METATYPE(QDBusSignature)

struct QDBusVariant
{
    inline QDBusVariant() { }
    inline explicit QDBusVariant(const QVariant &variant) : value(variant) { }
    QVariant value;
};
Q_DECLARE_METATYPE(QDBusVariant)

QT_END_HEADER

#endif
