/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "q3datetimeedit_plugin.h"

#include <QtCore/qplugin.h>
#include <QtGui/QIcon>
#include <Qt3Support/Q3DateTimeEdit>

Q3DateTimeEditPlugin::Q3DateTimeEditPlugin(QObject *parent)
        : QObject(parent), m_initialized(false)
{}

QString Q3DateTimeEditPlugin::name() const
{ return QLatin1String("Q3DateTimeEdit"); }

QString Q3DateTimeEditPlugin::group() const
{ return QLatin1String("Qt 3 Support"); }

QString Q3DateTimeEditPlugin::toolTip() const
{ return QString(); }

QString Q3DateTimeEditPlugin::whatsThis() const
{ return QString(); }

QString Q3DateTimeEditPlugin::includeFile() const
{ return QLatin1String("Qt3Support/Q3DateTimeEdit"); }

QIcon Q3DateTimeEditPlugin::icon() const
{ return QIcon(); }

bool Q3DateTimeEditPlugin::isContainer() const
{ return false; }

QWidget *Q3DateTimeEditPlugin::createWidget(QWidget *parent)
{ return new Q3DateTimeEdit(parent); }

bool Q3DateTimeEditPlugin::isInitialized() const
{ return m_initialized; }

void Q3DateTimeEditPlugin::initialize(QDesignerFormEditorInterface *core)
{
    Q_UNUSED(core);
    m_initialized = true;
}
