/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qdesigner.h"
#include "qdesigner_actioneditor.h"
#include "qdesigner_workbench.h"

#include <QtDesigner/QtDesigner>
#include <QtDesigner/QDesignerComponents>

QDesignerActionEditor::QDesignerActionEditor(QDesignerWorkbench *workbench)
    : QDesignerToolWindow(workbench)
{
    setObjectName(QLatin1String("ActionEditor"));
    QDesignerActionEditorInterface *widget = QDesignerComponents::createActionEditor(workbench->core(), this);
    workbench->core()->setActionEditor(widget);

    setCentralWidget(widget);

    setWindowTitle(tr("Action Editor"));
}

QDesignerActionEditor::~QDesignerActionEditor()
{
}

QRect QDesignerActionEditor::geometryHint() const
{
    QRect g = workbench()->availableGeometry();
    int margin = workbench()->marginHint();

    QSize sz(g.width() * 1/4, g.height() * 1/6);

    return QRect((g.width() - sz.width() - margin), margin,
                  sz.width(), sz.height());
}
