/****************************************************************************
**
** Copyright (C) 2005-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef TILE_H
#define TILE_H

#include <qglobal.h>
#include <item.h>

class Tile
{
public:
    enum Type {
        Earth,
        Wall,
        ClosedDoor,
        OpenDoor,
        Floor
    };


    enum TileFlag {
        Default,
        Explored,
        Lit
    };
    Q_DECLARE_FLAGS(TileFlags, TileFlag)

    Tile (Type t = Earth, TileFlags f = Default) : type(t), flags(f) {}
    Type type;
    TileFlags flags;
    QList<const Item *> items;
};

Q_DECLARE_OPERATORS_FOR_FLAGS(Tile::TileFlags);

#endif
