/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QTBRUSHBUTTON_H
#define QTBRUSHBUTTON_H

#include <QToolButton>

class QDesignerBrushManagerInterface;

class QtBrushButton : public QToolButton
{
    Q_OBJECT
    Q_PROPERTY(bool backgroundTransparent READ backgroundTransparent WRITE setBackgroundTransparent)
public:
    QtBrushButton(QWidget *parent = 0);
    ~QtBrushButton();

    void setBackgroundTransparent(bool transparent);
    bool backgroundTransparent() const;

    void setBrush(const QBrush &brush);
    QBrush brush() const;

    void setBrushManager(QDesignerBrushManagerInterface *manager);

    void setTexture(const QPixmap &texture);
signals:
    void brushChanged(const QBrush &brush);
    void textureChooserActivated(QWidget *parent, const QBrush &initialBrush);
protected:
    void paintEvent(QPaintEvent *e);

private:
    class QtBrushButtonPrivate *d_ptr;
    Q_DECLARE_PRIVATE(QtBrushButton)
    Q_DISABLE_COPY(QtBrushButton)
    Q_PRIVATE_SLOT(d_func(), void slotEditBrush());
};

#endif
