/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the Qt3Support module of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef Q3VALUESTACK_H
#define Q3VALUESTACK_H

#include <Qt3Support/q3valuelist.h>

QT_BEGIN_HEADER

QT_MODULE(Qt3SupportLight)

template<class T>
class Q3ValueStack : public Q3ValueList<T>
{
public:
    Q3ValueStack() {}
   ~Q3ValueStack() {}
    void  push(const T& val) { this->append(val); }
    T pop()
    {
        T elem(this->last());
        if (!this->isEmpty())
            this->remove(this->fromLast());
        return elem;
    }
    T& top() { return this->last(); }
    const T& top() const { return this->last(); }
};

QT_END_HEADER

#endif // Q3VALUESTACK_H
