/****************************************************************************
**
** Copyright (C) 1992-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QBACKINGSTORE_P_H
#define QBACKINGSTORE_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include "private/qpaintengine_raster_p.h"
#ifdef Q_WS_QWS
#include "private/qwidget_qws_p.h"
#endif

#ifndef QT_WINDOW_SURFACE
#ifdef Q_WS_WIN
class QBackingStoreDevice : public QPaintDevice
{
    QRasterPaintEngine engine;
    QWidget *tlw;

public:
    QBackingStoreDevice(QWidget *topLevel) : tlw(topLevel)  { engine.setFlushOnEnd(false); }
    QSize size() const { return engine.size(); }
    virtual int metric(PaintDeviceMetric metric) const {  return tlw->metric(metric); }
    QPaintEngine *paintEngine() const { return const_cast<QRasterPaintEngine *>(&engine); }
};
#endif
#endif // QT_WINDOW_SURFACE

#ifdef QT_WINDOW_SURFACE
class QWindowSurface;
#endif

class QWidgetBackingStore
{
public:
    QWidgetBackingStore(QWidget *t);
    ~QWidgetBackingStore();
    void bltRect(const QRect &rect, int dx, int dy, QWidget *widget);
    void dirtyRegion(const QRegion &rgn, QWidget *widget=0);
    void cleanRegion(const QRegion &rgn, QWidget *widget=0, bool recursiveCopyToScreen = true);
#ifndef QT_WINDOW_SURFACE
#if defined(Q_WS_X11)
    QPixmap backingPixmap() const { return buffer; }
#elif defined(Q_WS_QWS)
    const QImage &backingImage()  { return buffer.image(); }
#endif
#endif // QT_WINDOW_SURFACE
#if defined (Q_WS_QWS) || defined (Q_WS_WIN)
    void releaseBuffer();
#endif

    inline QPoint topLevelOffset() const { return tlwOffset; }
    static bool paintOnScreen(QWidget * = 0);
    static void copyToScreen(QWidget *, const QRegion &);
#ifdef Q_WS_WIN
    static void blitToScreen(const QRegion &rgn, QWidget *w);
#endif
private:
    QWidget *tlw;
    QRegion dirty;

#ifdef QT_WINDOW_SURFACE
    QWindowSurface *windowSurface;
#else

#if defined(Q_WS_WIN)
    QBackingStoreDevice buffer;
#elif defined(Q_WS_QWS)
    QWSBackingStore buffer;
    QRegion dirty_on_screen;
#else
    QPixmap buffer;
#endif

#endif // QT_WINDOW_SURFACE

    QPoint tlwOffset;

    static bool isOpaque(const QWidget *widget);

    void copyToScreen(const QRegion &rgn, QWidget *widget, const QPoint &offset, bool recursive = true);

    static void paintSiblingsRecursive(QPaintDevice *pdev, const QObjectList& children, int index, const QRegion &rgn, const QPoint &offset, int flags);

    friend void qt_syncBackingStore(QRegion, QWidget *);
#if defined(Q_WS_X11) || defined(Q_WS_QWS)
    friend void qt_syncBackingStore(QWidget *);
#endif
    friend class QWidgetPrivate;
    friend class QWidget;
    friend class QWSManagerPrivate;
    friend class QETWidget;
};

#endif // QBACKINGSTORE_P_H
