/****************************************************************************
**
** Copyright (C) 2005-2006 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** Licensees holding valid Qt Preview licenses may use this file in
** accordance with the Qt Preview License Agreement provided with the
** Software.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef POPUPWIDGET_H
#define POPUPWIDGET_H

#include <QWidget>
#include <QEventLoop>

//The class to show a widget as popup.
class PopupWidget: public QWidget
{
    Q_OBJECT
public:
    PopupWidget(QWidget *parent = 0);
    ~PopupWidget();
    void setWidget(QWidget * widget);
    QWidget *widget() const;
    //position of the popup has to be in the screen coordinates.
    int exec(const QRect& rect);

public slots:
    void closePopup();

protected:
    void hideEvent(QHideEvent * event);

private:
    QWidget *childWidget;
    QEventLoop *eventLoop;
    int returnCode;
};

#endif
