/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the Qt Designer of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may only be used for
** evaluation and testing purposes.  It may not be used for commercial
** development.  You may use this file in accordance with the terms and
** conditions contained in the either Technology Preview License
** Agreement or the Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include "videoplayerplugin.h"
#include "videoplayertaskmenu.h"

#include <QtDesigner/QExtensionFactory>
#include <QtDesigner/QExtensionManager>
#include <QtDesigner/QDesignerFormEditorInterface>

#include <QtCore/qplugin.h>
#include <phonon/videoplayer.h>

static const char *toolTipC = "Phonon Video Player";

QT_BEGIN_NAMESPACE

VideoPlayerPlugin::VideoPlayerPlugin(const QString &group, QObject *parent) :
    QObject(parent),
    m_group(group),
    m_initialized(false)
{
}

QString VideoPlayerPlugin::name() const
{
    return QLatin1String("Phonon::VideoPlayer");
}

QString VideoPlayerPlugin::group() const
{
    return m_group;
}

QString VideoPlayerPlugin::toolTip() const
{
    return QString(QLatin1String(toolTipC));
}

QString VideoPlayerPlugin::whatsThis() const
{
    return QString(QLatin1String(toolTipC));
}

QString VideoPlayerPlugin::includeFile() const
{
    return QLatin1String("<phonon/videoplayer.h>");
}

QIcon VideoPlayerPlugin::icon() const
{
    return QIcon(QLatin1String(":/trolltech/phononwidgets/images/videoplayer.png"));
}

bool VideoPlayerPlugin::isContainer() const
{
    return false;
}

QWidget *VideoPlayerPlugin::createWidget(QWidget *parent)
{
    return new Phonon::VideoPlayer(Phonon::NoCategory, parent);
}

bool VideoPlayerPlugin::isInitialized() const
{
    return m_initialized;
}

void VideoPlayerPlugin::initialize(QDesignerFormEditorInterface * core)
{
    if (m_initialized)
        return;

    QExtensionManager *mgr = core->extensionManager();
    VideoPlayerTaskMenuFactory::registerExtension(mgr, Q_TYPEID(QDesignerTaskMenuExtension));
    m_initialized = true;
}

QString VideoPlayerPlugin::domXml() const
{
    return QLatin1String("\
    <ui language=\"c++\">\
        <widget class=\"Phonon::VideoPlayer\" name=\"videoPlayer\">\
            <property name=\"geometry\">\
                <rect>\
                    <x>0</x>\
                    <y>0</y>\
                    <width>300</width>\
                    <height>200</height>\
                </rect>\
            </property>\
        </widget>\
    </ui>");
}

QT_END_NAMESPACE
