/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the QtOpenGL module of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may only be used for
** evaluation and testing purposes.  It may not be used for commercial
** development.  You may use this file in accordance with the terms and
** conditions contained in the either Technology Preview License
** Agreement or the Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

static const char* qglImageVertexShaderSource = "\
    attribute highp vec4    inputVertex; \
    attribute lowp  vec2    textureCoord; \
    uniform   highp mat4    pmvMatrix; \
    varying   lowp  vec2    fragTextureCoord; \
    void main(void) \
    {\
            gl_Position = pmvMatrix * inputVertex;\
            fragTextureCoord = textureCoord; \
    }";

static const char* qglImageFragmentShaderSource = "\
    varying lowp vec2      fragTextureCoord;\
    uniform      sampler2D textureSampler;\
    uniform lowp float     opacity; \
    void main(void) \
    {\
        gl_FragColor = texture2D(textureSampler, fragTextureCoord) * opacity; \
    }";




// This adds 0.5 to x & y values passed in. This is to move the point to the center
// of the pixel square and improve pixel-precision
static const char* qglVertexShaderSource = "\
    attribute highp vec4    inputVertex;\
    uniform   highp mat4    pmvMatrix;\
    void main(void)\
    {\
            gl_Position = pmvMatrix * inputVertex;\
    }";

// Simple fragment shader - fills with white
static const char* qglSimpleFragShaderSource = "\
    void main (void)\
    {\
            gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);\
    }";

static const char* qglNoBrushSource = "\
    void main (void) { \
        discard; \
    }";

static const char* qglFragmentShaderMainSource = "\
    mediump vec4 brush();\
    void main (void)\
    {\
            gl_FragColor = brush();\
    }\n";

// Solid Fill Brush
static const char* qglSolidBrushSource = "\
    uniform mediump vec4 fragmentColor; \
    mediump vec4 brush() { \
        return fragmentColor;\
    }";

static const char* qglTextureBrushSource = "\
    uniform         sampler2D  brushTexture; \
    uniform mediump vec2       invertedBrushTextureSize; \
    uniform highp   mat3       brushTransform; \
    uniform lowp    float      opacity; \
\
    mediump vec4 brush() \
    { \
        highp vec3 hcoords = brushTransform * vec3(gl_FragCoord.xy, 1); \
        highp vec2 coords = hcoords.xy / hcoords.z; \
\
        coords *= invertedBrushTextureSize; \
        coords.y = -coords.y; \
\
        return texture2D(brushTexture, coords) * opacity;\
    }";

// Linear Gradient Brush
static const char* qglLinearGradientBrushSource = "\
    uniform         sampler2D   brushTexture; \
    uniform highp   vec3        linear; \
    uniform highp   mat3        brushTransform; \
    uniform lowp    float       opacity; \
\
    mediump vec4 brush() { \
        highp vec3 hcoords = brushTransform * vec3(gl_FragCoord.xy, 1); \
        highp vec2 coords = hcoords.xy / hcoords.z; \
        mediump vec2 val; \
        val.x = dot(linear.xy, coords) * linear.z; \
        val.y = 0.5; \
        return texture2D(brushTexture, val) * opacity; \
    }";


// NOTE: The texture is already pre-multiplied, all this does is apply the
//       global opacity (which defaults to 1.0 if not set.
static const char* qglRadialGradientBrushSource = "\
    uniform         sampler2D   brushTexture; \
    uniform highp   vec2        fmp; \
    uniform highp   float       fmp2_m_radius2; \
    uniform highp   mat3        brushTransform; \
    uniform lowp    float       opacity; \
\
    mediump vec4 brush() { \
        highp vec3 hcoords = brushTransform * vec3(gl_FragCoord.xy, 1); \
        highp vec2 A = hcoords.xy / hcoords.z; \
        highp vec2 B = fmp; \
\
        highp float a = fmp2_m_radius2; \
        highp float b = 2.0*dot(A, B); \
        highp float c = -dot(A, A); \
\
        highp vec2 val = vec2((-b + sqrt(b*b - 4.0*a*c)) / (2.0*a), 0.5); \
        return texture2D(brushTexture, val) * opacity; \
    }";

static const char* qglConicalGradientBrushSource = "\
    uniform         sampler2D   brushTexture; \
    uniform mediump float       angle; \
    uniform highp   mat3        brushTransform; \
    uniform lowp    float       opacity; \
\
    mediump vec4 brush() { \
        highp vec3 hcoords = brushTransform * vec3(gl_FragCoord.xy, 1); \
        highp vec2 A = hcoords.xy / hcoords.z; \
        if (abs(A.y) == abs(A.x)) \
            A.y += 0.002; \
        highp float t = (atan2(-A.y, A.x) + angle) / (2.0 * 3.14159265358979323846); \
        return texture2D(brushTexture, vec2(t - floor(t), 0.5)) * opacity; \
    }";


// NOTE: This assumes the texture size is 8x8 and thus, the inverted size is 0.125
static const char* qglPatternBrushSource = "\
    uniform lowp    vec4       patternColor; \
    uniform         sampler2D  brushTexture; \
    uniform highp   mat3       brushTransform; \
\
    mediump vec4 brush() { \
        highp vec3 hcoords = brushTransform * vec3(gl_FragCoord.xy, 1); \
        highp vec2 coords = hcoords.xy / hcoords.z; \
\
        coords *= 0.125; \
        coords.y = -coords.y; \
\
        lowp float alpha = texture2D(brushTexture, coords).r; \
\
        return patternColor * alpha; \
    }";
