/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathExpression.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSXPathResult.h"
#include "XPathExpression.h"
#include "XPathResult.h"

#include <kjs/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXPathExpression)

/* Hash table for prototype */

static const HashTableValue JSXPathExpressionPrototypeTableValues[2] =
{
    { "evaluate", DontDelete|Function, (intptr_t)jsXPathExpressionPrototypeFunctionEvaluate, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathExpressionPrototypeTable = { 0, JSXPathExpressionPrototypeTableValues, 0 };

const ClassInfo JSXPathExpressionPrototype::s_info = { "XPathExpressionPrototype", 0, &JSXPathExpressionPrototypeTable, 0 };

JSObject* JSXPathExpressionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSXPathExpression>(exec);
}

bool JSXPathExpressionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSXPathExpressionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXPathExpression::s_info = { "XPathExpression", 0, 0 , 0 };

JSXPathExpression::JSXPathExpression(PassRefPtr<StructureID> structure, PassRefPtr<XPathExpression> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSXPathExpression::~JSXPathExpression()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSXPathExpression::createPrototype(ExecState* exec)
{
    return new (exec) JSXPathExpressionPrototype(JSXPathExpressionPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

JSValue* jsXPathExpressionPrototypeFunctionEvaluate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathExpression::s_info))
        return throwError(exec, TypeError);
    JSXPathExpression* castedThisObj = static_cast<JSXPathExpression*>(thisValue);
    XPathExpression* imp = static_cast<XPathExpression*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* contextNode = toNode(args.at(exec, 0));
    unsigned short type = args.at(exec, 1)->toInt32(exec);
    XPathResult* inResult = toXPathResult(args.at(exec, 2));


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->evaluate(contextNode, type, inResult, ec)));
    setDOMException(exec, ec);
    return result;
}

JSC::JSValue* toJS(JSC::ExecState* exec, XPathExpression* object)
{
    return getDOMObjectWrapper<JSXPathExpression>(exec, object);
}
XPathExpression* toXPathExpression(JSC::JSValue* val)
{
    return val->isObject(&JSXPathExpression::s_info) ? static_cast<JSXPathExpression*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
