/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSXMLHttpRequestUpload.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "EventListener.h"
#include "Frame.h"
#include "JSDOMWindow.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "XMLHttpRequestUpload.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXMLHttpRequestUpload)

/* Hash table */

static const HashTableValue JSXMLHttpRequestUploadTableValues[7] =
{
    { "onabort", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnabort, (intptr_t)setJSXMLHttpRequestUploadOnabort },
    { "onerror", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnerror, (intptr_t)setJSXMLHttpRequestUploadOnerror },
    { "onload", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnload, (intptr_t)setJSXMLHttpRequestUploadOnload },
    { "onloadstart", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnloadstart, (intptr_t)setJSXMLHttpRequestUploadOnloadstart },
    { "onprogress", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnprogress, (intptr_t)setJSXMLHttpRequestUploadOnprogress },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsXMLHttpRequestUploadConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestUploadTable = { 15, JSXMLHttpRequestUploadTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSXMLHttpRequestUploadConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestUploadConstructorTable = { 0, JSXMLHttpRequestUploadConstructorTableValues, 0 };

class JSXMLHttpRequestUploadConstructor : public DOMObject {
public:
    JSXMLHttpRequestUploadConstructor(ExecState* exec)
        : DOMObject(JSXMLHttpRequestUploadConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSXMLHttpRequestUploadPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSXMLHttpRequestUploadConstructor::s_info = { "XMLHttpRequestUploadConstructor", 0, &JSXMLHttpRequestUploadConstructorTable, 0 };

bool JSXMLHttpRequestUploadConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestUploadConstructor, DOMObject>(exec, &JSXMLHttpRequestUploadConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestUploadPrototypeTableValues[4] =
{
    { "addEventListener", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestUploadPrototypeTable = { 3, JSXMLHttpRequestUploadPrototypeTableValues, 0 };

const ClassInfo JSXMLHttpRequestUploadPrototype::s_info = { "XMLHttpRequestUploadPrototype", 0, &JSXMLHttpRequestUploadPrototypeTable, 0 };

JSObject* JSXMLHttpRequestUploadPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSXMLHttpRequestUpload>(exec);
}

bool JSXMLHttpRequestUploadPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSXMLHttpRequestUploadPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXMLHttpRequestUpload::s_info = { "XMLHttpRequestUpload", 0, &JSXMLHttpRequestUploadTable , 0 };

JSXMLHttpRequestUpload::JSXMLHttpRequestUpload(PassRefPtr<StructureID> structure, PassRefPtr<XMLHttpRequestUpload> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSXMLHttpRequestUpload::~JSXMLHttpRequestUpload()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSXMLHttpRequestUpload::createPrototype(ExecState* exec)
{
    return new (exec) JSXMLHttpRequestUploadPrototype(JSXMLHttpRequestUploadPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSXMLHttpRequestUpload::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestUpload, Base>(exec, &JSXMLHttpRequestUploadTable, this, propertyName, slot);
}

JSValue* jsXMLHttpRequestUploadOnabort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(slot.slotBase())->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onabort())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsXMLHttpRequestUploadOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(slot.slotBase())->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onerror())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsXMLHttpRequestUploadOnload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(slot.slotBase())->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onload())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsXMLHttpRequestUploadOnloadstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(slot.slotBase())->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onloadstart())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsXMLHttpRequestUploadOnprogress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(slot.slotBase())->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onprogress())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValue* jsXMLHttpRequestUploadConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSXMLHttpRequestUpload*>(slot.slotBase())->getConstructor(exec);
}
void JSXMLHttpRequestUpload::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSXMLHttpRequestUpload, Base>(exec, propertyName, value, &JSXMLHttpRequestUploadTable, this, slot);
}

void setJSXMLHttpRequestUploadOnabort(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    Frame* frame = imp->associatedFrame();
    if (!frame)
        return;
    JSDOMWindow* window = toJSDOMWindow(frame);
    imp->setOnabort(window->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSXMLHttpRequestUploadOnerror(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    Frame* frame = imp->associatedFrame();
    if (!frame)
        return;
    JSDOMWindow* window = toJSDOMWindow(frame);
    imp->setOnerror(window->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSXMLHttpRequestUploadOnload(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    Frame* frame = imp->associatedFrame();
    if (!frame)
        return;
    JSDOMWindow* window = toJSDOMWindow(frame);
    imp->setOnload(window->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSXMLHttpRequestUploadOnloadstart(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    Frame* frame = imp->associatedFrame();
    if (!frame)
        return;
    JSDOMWindow* window = toJSDOMWindow(frame);
    imp->setOnloadstart(window->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSXMLHttpRequestUploadOnprogress(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    Frame* frame = imp->associatedFrame();
    if (!frame)
        return;
    JSDOMWindow* window = toJSDOMWindow(frame);
    imp->setOnprogress(window->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

JSValue* JSXMLHttpRequestUpload::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSXMLHttpRequestUploadConstructor>(exec);
}

JSValue* jsXMLHttpRequestUploadPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(thisValue);
    return castedThisObj->addEventListener(exec, args);
}

JSValue* jsXMLHttpRequestUploadPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(thisValue);
    return castedThisObj->removeEventListener(exec, args);
}

JSValue* jsXMLHttpRequestUploadPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(thisValue);
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(exec, 0));


    JSC::JSValue* result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

JSC::JSValue* toJS(JSC::ExecState* exec, XMLHttpRequestUpload* object)
{
    return getDOMObjectWrapper<JSXMLHttpRequestUpload>(exec, object);
}
XMLHttpRequestUpload* toXMLHttpRequestUpload(JSC::JSValue* val)
{
    return val->isObject(&JSXMLHttpRequestUpload::s_info) ? static_cast<JSXMLHttpRequestUpload*>(val)->impl() : 0;
}

}
