/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSXMLHttpRequestException.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "XMLHttpRequestException.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXMLHttpRequestException)

/* Hash table */

static const HashTableValue JSXMLHttpRequestExceptionTableValues[5] =
{
    { "code", DontDelete|ReadOnly, (intptr_t)jsXMLHttpRequestExceptionCode, (intptr_t)0 },
    { "name", DontDelete|ReadOnly, (intptr_t)jsXMLHttpRequestExceptionName, (intptr_t)0 },
    { "message", DontDelete|ReadOnly, (intptr_t)jsXMLHttpRequestExceptionMessage, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsXMLHttpRequestExceptionConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestExceptionTable = { 127, JSXMLHttpRequestExceptionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSXMLHttpRequestExceptionConstructorTableValues[3] =
{
    { "NETWORK_ERR", DontDelete|ReadOnly, (intptr_t)jsXMLHttpRequestExceptionNETWORK_ERR, (intptr_t)0 },
    { "ABORT_ERR", DontDelete|ReadOnly, (intptr_t)jsXMLHttpRequestExceptionABORT_ERR, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestExceptionConstructorTable = { 1, JSXMLHttpRequestExceptionConstructorTableValues, 0 };

class JSXMLHttpRequestExceptionConstructor : public DOMObject {
public:
    JSXMLHttpRequestExceptionConstructor(ExecState* exec)
        : DOMObject(JSXMLHttpRequestExceptionConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSXMLHttpRequestExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSXMLHttpRequestExceptionConstructor::s_info = { "XMLHttpRequestExceptionConstructor", 0, &JSXMLHttpRequestExceptionConstructorTable, 0 };

bool JSXMLHttpRequestExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestExceptionConstructor, DOMObject>(exec, &JSXMLHttpRequestExceptionConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestExceptionPrototypeTableValues[4] =
{
    { "NETWORK_ERR", DontDelete|ReadOnly, (intptr_t)jsXMLHttpRequestExceptionNETWORK_ERR, (intptr_t)0 },
    { "ABORT_ERR", DontDelete|ReadOnly, (intptr_t)jsXMLHttpRequestExceptionABORT_ERR, (intptr_t)0 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsXMLHttpRequestExceptionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestExceptionPrototypeTable = { 3, JSXMLHttpRequestExceptionPrototypeTableValues, 0 };

const ClassInfo JSXMLHttpRequestExceptionPrototype::s_info = { "XMLHttpRequestExceptionPrototype", 0, &JSXMLHttpRequestExceptionPrototypeTable, 0 };

JSObject* JSXMLHttpRequestExceptionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSXMLHttpRequestException>(exec);
}

bool JSXMLHttpRequestExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXMLHttpRequestExceptionPrototype, JSObject>(exec, &JSXMLHttpRequestExceptionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXMLHttpRequestException::s_info = { "XMLHttpRequestException", 0, &JSXMLHttpRequestExceptionTable , 0 };

JSXMLHttpRequestException::JSXMLHttpRequestException(PassRefPtr<StructureID> structure, PassRefPtr<XMLHttpRequestException> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSXMLHttpRequestException::~JSXMLHttpRequestException()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSXMLHttpRequestException::createPrototype(ExecState* exec)
{
    return new (exec) JSXMLHttpRequestExceptionPrototype(JSXMLHttpRequestExceptionPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSXMLHttpRequestException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestException, Base>(exec, &JSXMLHttpRequestExceptionTable, this, propertyName, slot);
}

JSValue* jsXMLHttpRequestExceptionCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestException* imp = static_cast<XMLHttpRequestException*>(static_cast<JSXMLHttpRequestException*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->code());
}

JSValue* jsXMLHttpRequestExceptionName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestException* imp = static_cast<XMLHttpRequestException*>(static_cast<JSXMLHttpRequestException*>(slot.slotBase())->impl());
    return jsString(exec, imp->name());
}

JSValue* jsXMLHttpRequestExceptionMessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestException* imp = static_cast<XMLHttpRequestException*>(static_cast<JSXMLHttpRequestException*>(slot.slotBase())->impl());
    return jsString(exec, imp->message());
}

JSValue* jsXMLHttpRequestExceptionConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSXMLHttpRequestException*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSXMLHttpRequestException::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSXMLHttpRequestExceptionConstructor>(exec);
}

JSValue* jsXMLHttpRequestExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXMLHttpRequestException::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestException* castedThisObj = static_cast<JSXMLHttpRequestException*>(thisValue);
    XMLHttpRequestException* imp = static_cast<XMLHttpRequestException*>(castedThisObj->impl());


    JSC::JSValue* result = jsString(exec, imp->toString());
    return result;
}

// Constant getters

JSValue* jsXMLHttpRequestExceptionNETWORK_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(101));
}

JSValue* jsXMLHttpRequestExceptionABORT_ERR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(102));
}

JSC::JSValue* toJS(JSC::ExecState* exec, XMLHttpRequestException* object)
{
    return getDOMObjectWrapper<JSXMLHttpRequestException>(exec, object);
}
XMLHttpRequestException* toXMLHttpRequestException(JSC::JSValue* val)
{
    return val->isObject(&JSXMLHttpRequestException::s_info) ? static_cast<JSXMLHttpRequestException*>(val)->impl() : 0;
}

}
