/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGFECompositeElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFECompositeElement.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFECompositeElement)

/* Hash table */

static const HashTableValue JSSVGFECompositeElementTableValues[16] =
{
    { "in1", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementIn1, (intptr_t)0 },
    { "in2", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementIn2, (intptr_t)0 },
    { "_operator", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElement_operator, (intptr_t)0 },
    { "k1", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementK1, (intptr_t)0 },
    { "k2", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementK2, (intptr_t)0 },
    { "k3", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementK3, (intptr_t)0 },
    { "k4", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementK4, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementStyle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGFECompositeElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFECompositeElementTable = { 255, JSSVGFECompositeElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSSVGFECompositeElementConstructorTableValues[8] =
{
    { "SVG_FECOMPOSITE_OPERATOR_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_UNKNOWN, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_OVER", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OVER, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_IN", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_IN, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_OUT", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OUT, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_ATOP", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ATOP, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_XOR", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_XOR, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_ARITHMETIC", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ARITHMETIC, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFECompositeElementConstructorTable = { 15, JSSVGFECompositeElementConstructorTableValues, 0 };

class JSSVGFECompositeElementConstructor : public DOMObject {
public:
    JSSVGFECompositeElementConstructor(ExecState* exec)
        : DOMObject(JSSVGFECompositeElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGFECompositeElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGFECompositeElementConstructor::s_info = { "SVGFECompositeElementConstructor", 0, &JSSVGFECompositeElementConstructorTable, 0 };

bool JSSVGFECompositeElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFECompositeElementConstructor, DOMObject>(exec, &JSSVGFECompositeElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFECompositeElementPrototypeTableValues[9] =
{
    { "SVG_FECOMPOSITE_OPERATOR_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_UNKNOWN, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_OVER", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OVER, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_IN", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_IN, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_OUT", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OUT, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_ATOP", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ATOP, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_XOR", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_XOR, (intptr_t)0 },
    { "SVG_FECOMPOSITE_OPERATOR_ARITHMETIC", DontDelete|ReadOnly, (intptr_t)jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ARITHMETIC, (intptr_t)0 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFECompositeElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFECompositeElementPrototypeTable = { 63, JSSVGFECompositeElementPrototypeTableValues, 0 };

const ClassInfo JSSVGFECompositeElementPrototype::s_info = { "SVGFECompositeElementPrototype", 0, &JSSVGFECompositeElementPrototypeTable, 0 };

JSObject* JSSVGFECompositeElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGFECompositeElement>(exec);
}

bool JSSVGFECompositeElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGFECompositeElementPrototype, JSObject>(exec, &JSSVGFECompositeElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGFECompositeElement::s_info = { "SVGFECompositeElement", &JSSVGElement::s_info, &JSSVGFECompositeElementTable , 0 };

JSSVGFECompositeElement::JSSVGFECompositeElement(PassRefPtr<StructureID> structure, PassRefPtr<SVGFECompositeElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGFECompositeElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGFECompositeElementPrototype(JSSVGFECompositeElementPrototype::createStructureID(JSSVGElementPrototype::self(exec)));
}

bool JSSVGFECompositeElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFECompositeElement, Base>(exec, &JSSVGFECompositeElementTable, this, propertyName, slot);
}

JSValue* jsSVGFECompositeElementIn1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->in1Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementIn2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->in2Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElement_operator(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->_operatorAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementK1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->k1Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementK2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->k2Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementK3(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->k3Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementK4(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->k4Animated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGFECompositeElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(static_cast<JSSVGFECompositeElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValue* jsSVGFECompositeElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGFECompositeElement*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSSVGFECompositeElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGFECompositeElementConstructor>(exec);
}

JSValue* jsSVGFECompositeElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGFECompositeElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFECompositeElement* castedThisObj = static_cast<JSSVGFECompositeElement*>(thisValue);
    SVGFECompositeElement* imp = static_cast<SVGFECompositeElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

// Constant getters

JSValue* jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OVER(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_IN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OUT(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue* jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ATOP(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue* jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_XOR(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSValue* jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ARITHMETIC(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(6));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
