/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGAnimatedString.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "PlatformString.h"

#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedString)

/* Hash table */

static const HashTableValue JSSVGAnimatedStringTableValues[3] =
{
    { "baseVal", DontDelete, (intptr_t)jsSVGAnimatedStringBaseVal, (intptr_t)setJSSVGAnimatedStringBaseVal },
    { "animVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedStringAnimVal, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedStringTable = { 1, JSSVGAnimatedStringTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedStringPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedStringPrototypeTable = { 0, JSSVGAnimatedStringPrototypeTableValues, 0 };

const ClassInfo JSSVGAnimatedStringPrototype::s_info = { "SVGAnimatedStringPrototype", 0, &JSSVGAnimatedStringPrototypeTable, 0 };

JSObject* JSSVGAnimatedStringPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGAnimatedString>(exec);
}

const ClassInfo JSSVGAnimatedString::s_info = { "SVGAnimatedString", 0, &JSSVGAnimatedStringTable , 0 };

JSSVGAnimatedString::JSSVGAnimatedString(PassRefPtr<StructureID> structure, PassRefPtr<SVGAnimatedString> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGAnimatedString::~JSSVGAnimatedString()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGAnimatedString::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGAnimatedStringPrototype(JSSVGAnimatedStringPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGAnimatedString::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedString, Base>(exec, &JSSVGAnimatedStringTable, this, propertyName, slot);
}

JSValue* jsSVGAnimatedStringBaseVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(static_cast<JSSVGAnimatedString*>(slot.slotBase())->impl());
    return jsString(exec, imp->baseVal());
}

JSValue* jsSVGAnimatedStringAnimVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(static_cast<JSSVGAnimatedString*>(slot.slotBase())->impl());
    return jsString(exec, imp->animVal());
}

void JSSVGAnimatedString::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAnimatedString, Base>(exec, propertyName, value, &JSSVGAnimatedStringTable, this, slot);
}

void setJSSVGAnimatedStringBaseVal(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(static_cast<JSSVGAnimatedString*>(thisObject)->impl());
    imp->setBaseVal(value->toString(exec));
    if (static_cast<JSSVGAnimatedString*>(thisObject)->context())
        static_cast<JSSVGAnimatedString*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGAnimatedString*>(thisObject)->impl()->associatedAttributeName());
}

JSC::JSValue* toJS(JSC::ExecState* exec, SVGAnimatedString* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedString>(exec, object, context);
}
SVGAnimatedString* toSVGAnimatedString(JSC::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedString::s_info) ? static_cast<JSSVGAnimatedString*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
