/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGAnimatedNumber.h"

#include <wtf/GetPtr.h>


#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedNumber)

/* Hash table */

static const HashTableValue JSSVGAnimatedNumberTableValues[3] =
{
    { "baseVal", DontDelete, (intptr_t)jsSVGAnimatedNumberBaseVal, (intptr_t)setJSSVGAnimatedNumberBaseVal },
    { "animVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedNumberAnimVal, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedNumberTable = { 1, JSSVGAnimatedNumberTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedNumberPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedNumberPrototypeTable = { 0, JSSVGAnimatedNumberPrototypeTableValues, 0 };

const ClassInfo JSSVGAnimatedNumberPrototype::s_info = { "SVGAnimatedNumberPrototype", 0, &JSSVGAnimatedNumberPrototypeTable, 0 };

JSObject* JSSVGAnimatedNumberPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGAnimatedNumber>(exec);
}

const ClassInfo JSSVGAnimatedNumber::s_info = { "SVGAnimatedNumber", 0, &JSSVGAnimatedNumberTable , 0 };

JSSVGAnimatedNumber::JSSVGAnimatedNumber(PassRefPtr<StructureID> structure, PassRefPtr<SVGAnimatedNumber> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGAnimatedNumber::~JSSVGAnimatedNumber()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGAnimatedNumber::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGAnimatedNumberPrototype(JSSVGAnimatedNumberPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGAnimatedNumber::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedNumber, Base>(exec, &JSSVGAnimatedNumberTable, this, propertyName, slot);
}

JSValue* jsSVGAnimatedNumberBaseVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedNumber* imp = static_cast<SVGAnimatedNumber*>(static_cast<JSSVGAnimatedNumber*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->baseVal());
}

JSValue* jsSVGAnimatedNumberAnimVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedNumber* imp = static_cast<SVGAnimatedNumber*>(static_cast<JSSVGAnimatedNumber*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->animVal());
}

void JSSVGAnimatedNumber::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAnimatedNumber, Base>(exec, propertyName, value, &JSSVGAnimatedNumberTable, this, slot);
}

void setJSSVGAnimatedNumberBaseVal(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGAnimatedNumber* imp = static_cast<SVGAnimatedNumber*>(static_cast<JSSVGAnimatedNumber*>(thisObject)->impl());
    imp->setBaseVal(value->toFloat(exec));
    if (static_cast<JSSVGAnimatedNumber*>(thisObject)->context())
        static_cast<JSSVGAnimatedNumber*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGAnimatedNumber*>(thisObject)->impl()->associatedAttributeName());
}

JSC::JSValue* toJS(JSC::ExecState* exec, SVGAnimatedNumber* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedNumber>(exec, object, context);
}
SVGAnimatedNumber* toSVGAnimatedNumber(JSC::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedNumber::s_info) ? static_cast<JSSVGAnimatedNumber*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
