/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGAnimatedLength.h"

#include <wtf/GetPtr.h>

#include "JSSVGLength.h"


using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedLength)

/* Hash table */

static const HashTableValue JSSVGAnimatedLengthTableValues[3] =
{
    { "baseVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedLengthBaseVal, (intptr_t)0 },
    { "animVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedLengthAnimVal, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedLengthTable = { 1, JSSVGAnimatedLengthTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedLengthPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedLengthPrototypeTable = { 0, JSSVGAnimatedLengthPrototypeTableValues, 0 };

const ClassInfo JSSVGAnimatedLengthPrototype::s_info = { "SVGAnimatedLengthPrototype", 0, &JSSVGAnimatedLengthPrototypeTable, 0 };

JSObject* JSSVGAnimatedLengthPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGAnimatedLength>(exec);
}

const ClassInfo JSSVGAnimatedLength::s_info = { "SVGAnimatedLength", 0, &JSSVGAnimatedLengthTable , 0 };

JSSVGAnimatedLength::JSSVGAnimatedLength(PassRefPtr<StructureID> structure, PassRefPtr<SVGAnimatedLength> impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGAnimatedLength::~JSSVGAnimatedLength()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGAnimatedLength::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGAnimatedLengthPrototype(JSSVGAnimatedLengthPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGAnimatedLength::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedLength, Base>(exec, &JSSVGAnimatedLengthTable, this, propertyName, slot);
}

JSValue* jsSVGAnimatedLengthBaseVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedLength* imp = static_cast<SVGAnimatedLength*>(static_cast<JSSVGAnimatedLength*>(slot.slotBase())->impl());
    return toJS(exec, JSSVGDynamicPODTypeWrapperCache<SVGLength, SVGAnimatedLength>::lookupOrCreateWrapper(imp, &SVGAnimatedLength::baseVal, &SVGAnimatedLength::setBaseVal).get(), static_cast<JSSVGAnimatedLength*>(slot.slotBase())->context());
}

JSValue* jsSVGAnimatedLengthAnimVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGAnimatedLength* imp = static_cast<SVGAnimatedLength*>(static_cast<JSSVGAnimatedLength*>(slot.slotBase())->impl());
    return toJS(exec, JSSVGDynamicPODTypeWrapperCache<SVGLength, SVGAnimatedLength>::lookupOrCreateWrapper(imp, &SVGAnimatedLength::animVal, &SVGAnimatedLength::setAnimVal).get(), static_cast<JSSVGAnimatedLength*>(slot.slotBase())->context());
}

JSC::JSValue* toJS(JSC::ExecState* exec, SVGAnimatedLength* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedLength>(exec, object, context);
}
SVGAnimatedLength* toSVGAnimatedLength(JSC::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedLength::s_info) ? static_cast<JSSVGAnimatedLength*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
