/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNodeIterator.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNodeIterator)

/* Hash table */

static const HashTableValue JSNodeIteratorTableValues[7] =
{
    { "root", DontDelete|ReadOnly, (intptr_t)jsNodeIteratorRoot, (intptr_t)0 },
    { "whatToShow", DontDelete|ReadOnly, (intptr_t)jsNodeIteratorWhatToShow, (intptr_t)0 },
    { "filter", DontDelete|ReadOnly, (intptr_t)jsNodeIteratorFilter, (intptr_t)0 },
    { "expandEntityReferences", DontDelete|ReadOnly, (intptr_t)jsNodeIteratorExpandEntityReferences, (intptr_t)0 },
    { "referenceNode", DontDelete|ReadOnly, (intptr_t)jsNodeIteratorReferenceNode, (intptr_t)0 },
    { "pointerBeforeReferenceNode", DontDelete|ReadOnly, (intptr_t)jsNodeIteratorPointerBeforeReferenceNode, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNodeIteratorTable = { 255, JSNodeIteratorTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSNodeIteratorPrototypeTableValues[4] =
{
    { "nextNode", DontDelete|Function, (intptr_t)jsNodeIteratorPrototypeFunctionNextNode, (intptr_t)0 },
    { "previousNode", DontDelete|Function, (intptr_t)jsNodeIteratorPrototypeFunctionPreviousNode, (intptr_t)0 },
    { "detach", DontDelete|Function, (intptr_t)jsNodeIteratorPrototypeFunctionDetach, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNodeIteratorPrototypeTable = { 3, JSNodeIteratorPrototypeTableValues, 0 };

const ClassInfo JSNodeIteratorPrototype::s_info = { "NodeIteratorPrototype", 0, &JSNodeIteratorPrototypeTable, 0 };

JSObject* JSNodeIteratorPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSNodeIterator>(exec);
}

bool JSNodeIteratorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNodeIteratorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNodeIterator::s_info = { "NodeIterator", 0, &JSNodeIteratorTable , 0 };

JSNodeIterator::JSNodeIterator(PassRefPtr<StructureID> structure, PassRefPtr<NodeIterator> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSNodeIterator::~JSNodeIterator()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSNodeIterator::createPrototype(ExecState* exec)
{
    return new (exec) JSNodeIteratorPrototype(JSNodeIteratorPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSNodeIterator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeIterator, Base>(exec, &JSNodeIteratorTable, this, propertyName, slot);
}

JSValue* jsNodeIteratorRoot(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    NodeIterator* imp = static_cast<NodeIterator*>(static_cast<JSNodeIterator*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->root()));
}

JSValue* jsNodeIteratorWhatToShow(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    NodeIterator* imp = static_cast<NodeIterator*>(static_cast<JSNodeIterator*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->whatToShow());
}

JSValue* jsNodeIteratorFilter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    NodeIterator* imp = static_cast<NodeIterator*>(static_cast<JSNodeIterator*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->filter()));
}

JSValue* jsNodeIteratorExpandEntityReferences(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    NodeIterator* imp = static_cast<NodeIterator*>(static_cast<JSNodeIterator*>(slot.slotBase())->impl());
    return jsBoolean(imp->expandEntityReferences());
}

JSValue* jsNodeIteratorReferenceNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    NodeIterator* imp = static_cast<NodeIterator*>(static_cast<JSNodeIterator*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->referenceNode()));
}

JSValue* jsNodeIteratorPointerBeforeReferenceNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    NodeIterator* imp = static_cast<NodeIterator*>(static_cast<JSNodeIterator*>(slot.slotBase())->impl());
    return jsBoolean(imp->pointerBeforeReferenceNode());
}

JSValue* jsNodeIteratorPrototypeFunctionNextNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNodeIterator::s_info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisValue);
    return castedThisObj->nextNode(exec, args);
}

JSValue* jsNodeIteratorPrototypeFunctionPreviousNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNodeIterator::s_info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisValue);
    return castedThisObj->previousNode(exec, args);
}

JSValue* jsNodeIteratorPrototypeFunctionDetach(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNodeIterator::s_info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisValue);
    NodeIterator* imp = static_cast<NodeIterator*>(castedThisObj->impl());

    imp->detach();
    return jsUndefined();
}

JSC::JSValue* toJS(JSC::ExecState* exec, NodeIterator* object)
{
    return getDOMObjectWrapper<JSNodeIterator>(exec, object);
}
NodeIterator* toNodeIterator(JSC::JSValue* val)
{
    return val->isObject(&JSNodeIterator::s_info) ? static_cast<JSNodeIterator*>(val)->impl() : 0;
}

}
