/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMessagePort.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "JSEvent.h"
#include "JSMessagePort.h"
#include "MessagePort.h"
#include "PlatformString.h"

#include <kjs/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMessagePort)

/* Hash table */

static const HashTableValue JSMessagePortTableValues[4] =
{
    { "active", DontDelete|ReadOnly, (intptr_t)jsMessagePortActive, (intptr_t)0 },
    { "onmessage", DontDelete, (intptr_t)jsMessagePortOnmessage, (intptr_t)setJSMessagePortOnmessage },
    { "onclose", DontDelete, (intptr_t)jsMessagePortOnclose, (intptr_t)setJSMessagePortOnclose },
    { 0, 0, 0, 0 }
};

static const HashTable JSMessagePortTable = { 3, JSMessagePortTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSMessagePortPrototypeTableValues[8] =
{
    { "postMessage", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionPostMessage, (intptr_t)2 },
    { "startConversation", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionStartConversation, (intptr_t)1 },
    { "start", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionStart, (intptr_t)0 },
    { "close", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionClose, (intptr_t)0 },
    { "addEventListener", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMessagePortPrototypeTable = { 127, JSMessagePortPrototypeTableValues, 0 };

const ClassInfo JSMessagePortPrototype::s_info = { "MessagePortPrototype", 0, &JSMessagePortPrototypeTable, 0 };

JSObject* JSMessagePortPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSMessagePort>(exec);
}

bool JSMessagePortPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMessagePortPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMessagePort::s_info = { "MessagePort", 0, &JSMessagePortTable , 0 };

JSMessagePort::JSMessagePort(PassRefPtr<StructureID> structure, PassRefPtr<MessagePort> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSMessagePort::~JSMessagePort()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSMessagePort::createPrototype(ExecState* exec)
{
    return new (exec) JSMessagePortPrototype(JSMessagePortPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSMessagePort::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessagePort, Base>(exec, &JSMessagePortTable, this, propertyName, slot);
}

JSValue* jsMessagePortActive(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MessagePort* imp = static_cast<MessagePort*>(static_cast<JSMessagePort*>(slot.slotBase())->impl());
    return jsBoolean(imp->active());
}

JSValue* jsMessagePortOnmessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSMessagePort*>(slot.slotBase())->onmessage(exec);
}

JSValue* jsMessagePortOnclose(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSMessagePort*>(slot.slotBase())->onclose(exec);
}

void JSMessagePort::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSMessagePort, Base>(exec, propertyName, value, &JSMessagePortTable, this, slot);
}

void setJSMessagePortOnmessage(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    static_cast<JSMessagePort*>(thisObject)->setOnmessage(exec, value);
}

void setJSMessagePortOnclose(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    static_cast<JSMessagePort*>(thisObject)->setOnclose(exec, value);
}

JSValue* jsMessagePortPrototypeFunctionPostMessage(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(thisValue);
    MessagePort* imp = static_cast<MessagePort*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& message = args.at(exec, 0)->toString(exec);

    int argsCount = args.size();
    if (argsCount < 2) {
        imp->postMessage(message, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }

    MessagePort* messagePort = toMessagePort(args.at(exec, 1));

    imp->postMessage(message, messagePort, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsMessagePortPrototypeFunctionStartConversation(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(thisValue);
    return castedThisObj->startConversation(exec, args);
}

JSValue* jsMessagePortPrototypeFunctionStart(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(thisValue);
    MessagePort* imp = static_cast<MessagePort*>(castedThisObj->impl());

    imp->start();
    return jsUndefined();
}

JSValue* jsMessagePortPrototypeFunctionClose(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(thisValue);
    MessagePort* imp = static_cast<MessagePort*>(castedThisObj->impl());

    imp->close();
    return jsUndefined();
}

JSValue* jsMessagePortPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(thisValue);
    return castedThisObj->addEventListener(exec, args);
}

JSValue* jsMessagePortPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(thisValue);
    return castedThisObj->removeEventListener(exec, args);
}

JSValue* jsMessagePortPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(thisValue);
    MessagePort* imp = static_cast<MessagePort*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(exec, 0));


    JSC::JSValue* result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

JSC::JSValue* toJS(JSC::ExecState* exec, MessagePort* object)
{
    return getDOMObjectWrapper<JSMessagePort>(exec, object);
}
MessagePort* toMessagePort(JSC::JSValue* val)
{
    return val->isObject(&JSMessagePort::s_info) ? static_cast<JSMessagePort*>(val)->impl() : 0;
}

}
