/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSJavaScriptCallFrame.h"

#include <wtf/GetPtr.h>

#include "JSJavaScriptCallFrame.h"
#include "JavaScriptCallFrame.h"
#include "KURL.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSJavaScriptCallFrame)

/* Hash table */

static const HashTableValue JSJavaScriptCallFrameTableValues[8] =
{
    { "caller", DontDelete|ReadOnly, (intptr_t)jsJavaScriptCallFrameCaller, (intptr_t)0 },
    { "sourceID", DontDelete|ReadOnly, (intptr_t)jsJavaScriptCallFrameSourceID, (intptr_t)0 },
    { "line", DontDelete|ReadOnly, (intptr_t)jsJavaScriptCallFrameLine, (intptr_t)0 },
    { "scopeChain", DontDelete|ReadOnly, (intptr_t)jsJavaScriptCallFrameScopeChain, (intptr_t)0 },
    { "thisObject", DontDelete|ReadOnly, (intptr_t)jsJavaScriptCallFrameThisObject, (intptr_t)0 },
    { "functionName", DontDelete|ReadOnly, (intptr_t)jsJavaScriptCallFrameFunctionName, (intptr_t)0 },
    { "type", DontDelete|ReadOnly, (intptr_t)jsJavaScriptCallFrameType, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSJavaScriptCallFrameTable = { 63, JSJavaScriptCallFrameTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSJavaScriptCallFramePrototypeTableValues[2] =
{
    { "evaluate", DontDelete|Function, (intptr_t)jsJavaScriptCallFramePrototypeFunctionEvaluate, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSJavaScriptCallFramePrototypeTable = { 0, JSJavaScriptCallFramePrototypeTableValues, 0 };

const ClassInfo JSJavaScriptCallFramePrototype::s_info = { "JavaScriptCallFramePrototype", 0, &JSJavaScriptCallFramePrototypeTable, 0 };

JSObject* JSJavaScriptCallFramePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSJavaScriptCallFrame>(exec);
}

bool JSJavaScriptCallFramePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSJavaScriptCallFramePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSJavaScriptCallFrame::s_info = { "JavaScriptCallFrame", 0, &JSJavaScriptCallFrameTable , 0 };

JSJavaScriptCallFrame::JSJavaScriptCallFrame(PassRefPtr<StructureID> structure, PassRefPtr<JavaScriptCallFrame> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSJavaScriptCallFrame::~JSJavaScriptCallFrame()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSJavaScriptCallFrame::createPrototype(ExecState* exec)
{
    return new (exec) JSJavaScriptCallFramePrototype(JSJavaScriptCallFramePrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSJavaScriptCallFrame::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSJavaScriptCallFrame, Base>(exec, &JSJavaScriptCallFrameTable, this, propertyName, slot);
}

JSValue* jsJavaScriptCallFrameCaller(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(static_cast<JSJavaScriptCallFrame*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->caller()));
}

JSValue* jsJavaScriptCallFrameSourceID(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(static_cast<JSJavaScriptCallFrame*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->sourceID());
}

JSValue* jsJavaScriptCallFrameLine(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(static_cast<JSJavaScriptCallFrame*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->line());
}

JSValue* jsJavaScriptCallFrameScopeChain(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSJavaScriptCallFrame*>(slot.slotBase())->scopeChain(exec);
}

JSValue* jsJavaScriptCallFrameThisObject(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSJavaScriptCallFrame*>(slot.slotBase())->thisObject(exec);
}

JSValue* jsJavaScriptCallFrameFunctionName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JavaScriptCallFrame* imp = static_cast<JavaScriptCallFrame*>(static_cast<JSJavaScriptCallFrame*>(slot.slotBase())->impl());
    return jsString(exec, imp->functionName());
}

JSValue* jsJavaScriptCallFrameType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSJavaScriptCallFrame*>(slot.slotBase())->type(exec);
}

JSValue* jsJavaScriptCallFramePrototypeFunctionEvaluate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSJavaScriptCallFrame::s_info))
        return throwError(exec, TypeError);
    JSJavaScriptCallFrame* castedThisObj = static_cast<JSJavaScriptCallFrame*>(thisValue);
    return castedThisObj->evaluate(exec, args);
}

JSC::JSValue* toJS(JSC::ExecState* exec, JavaScriptCallFrame* object)
{
    return getDOMObjectWrapper<JSJavaScriptCallFrame>(exec, object);
}
JavaScriptCallFrame* toJavaScriptCallFrame(JSC::JSValue* val)
{
    return val->isObject(&JSJavaScriptCallFrame::s_info) ? static_cast<JSJavaScriptCallFrame*>(val)->impl() : 0;
}

}
