/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLTableRowElement.h"

#include <wtf/GetPtr.h>

#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLTableRowElement.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "KURL.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLTableRowElement)

/* Hash table */

static const HashTableValue JSHTMLTableRowElementTableValues[10] =
{
    { "rowIndex", DontDelete|ReadOnly, (intptr_t)jsHTMLTableRowElementRowIndex, (intptr_t)0 },
    { "sectionRowIndex", DontDelete|ReadOnly, (intptr_t)jsHTMLTableRowElementSectionRowIndex, (intptr_t)0 },
    { "cells", DontDelete|ReadOnly, (intptr_t)jsHTMLTableRowElementCells, (intptr_t)0 },
    { "align", DontDelete, (intptr_t)jsHTMLTableRowElementAlign, (intptr_t)setJSHTMLTableRowElementAlign },
    { "bgColor", DontDelete, (intptr_t)jsHTMLTableRowElementBgColor, (intptr_t)setJSHTMLTableRowElementBgColor },
    { "ch", DontDelete, (intptr_t)jsHTMLTableRowElementCh, (intptr_t)setJSHTMLTableRowElementCh },
    { "chOff", DontDelete, (intptr_t)jsHTMLTableRowElementChOff, (intptr_t)setJSHTMLTableRowElementChOff },
    { "vAlign", DontDelete, (intptr_t)jsHTMLTableRowElementVAlign, (intptr_t)setJSHTMLTableRowElementVAlign },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLTableRowElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableRowElementTable = { 63, JSHTMLTableRowElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLTableRowElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableRowElementConstructorTable = { 0, JSHTMLTableRowElementConstructorTableValues, 0 };

class JSHTMLTableRowElementConstructor : public DOMObject {
public:
    JSHTMLTableRowElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLTableRowElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLTableRowElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLTableRowElementConstructor::s_info = { "HTMLTableRowElementConstructor", 0, &JSHTMLTableRowElementConstructorTable, 0 };

bool JSHTMLTableRowElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableRowElementConstructor, DOMObject>(exec, &JSHTMLTableRowElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableRowElementPrototypeTableValues[3] =
{
    { "insertCell", DontDelete|Function, (intptr_t)jsHTMLTableRowElementPrototypeFunctionInsertCell, (intptr_t)1 },
    { "deleteCell", DontDelete|Function, (intptr_t)jsHTMLTableRowElementPrototypeFunctionDeleteCell, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableRowElementPrototypeTable = { 1, JSHTMLTableRowElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLTableRowElementPrototype::s_info = { "HTMLTableRowElementPrototype", 0, &JSHTMLTableRowElementPrototypeTable, 0 };

JSObject* JSHTMLTableRowElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLTableRowElement>(exec);
}

bool JSHTMLTableRowElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLTableRowElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLTableRowElement::s_info = { "HTMLTableRowElement", &JSHTMLElement::s_info, &JSHTMLTableRowElementTable , 0 };

JSHTMLTableRowElement::JSHTMLTableRowElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLTableRowElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLTableRowElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLTableRowElementPrototype(JSHTMLTableRowElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLTableRowElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableRowElement, Base>(exec, &JSHTMLTableRowElementTable, this, propertyName, slot);
}

JSValue* jsHTMLTableRowElementRowIndex(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->rowIndex());
}

JSValue* jsHTMLTableRowElementSectionRowIndex(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->sectionRowIndex());
}

JSValue* jsHTMLTableRowElementCells(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->cells()));
}

JSValue* jsHTMLTableRowElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->align());
}

JSValue* jsHTMLTableRowElementBgColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->bgColor());
}

JSValue* jsHTMLTableRowElementCh(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->ch());
}

JSValue* jsHTMLTableRowElementChOff(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->chOff());
}

JSValue* jsHTMLTableRowElementVAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->vAlign());
}

JSValue* jsHTMLTableRowElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLTableRowElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLTableRowElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLTableRowElement, Base>(exec, propertyName, value, &JSHTMLTableRowElementTable, this, slot);
}

void setJSHTMLTableRowElementAlign(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(thisObject)->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableRowElementBgColor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(thisObject)->impl());
    imp->setBgColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableRowElementCh(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(thisObject)->impl());
    imp->setCh(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableRowElementChOff(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(thisObject)->impl());
    imp->setChOff(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableRowElementVAlign(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(static_cast<JSHTMLTableRowElement*>(thisObject)->impl());
    imp->setVAlign(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLTableRowElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLTableRowElementConstructor>(exec);
}

JSValue* jsHTMLTableRowElementPrototypeFunctionInsertCell(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableRowElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableRowElement* castedThisObj = static_cast<JSHTMLTableRowElement*>(thisValue);
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->insertCell(index, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsHTMLTableRowElementPrototypeFunctionDeleteCell(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableRowElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableRowElement* castedThisObj = static_cast<JSHTMLTableRowElement*>(thisValue);
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args.at(exec, 0)->toInt32(exec);

    imp->deleteCell(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
