/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLPreElement.h"

#include <wtf/GetPtr.h>

#include "HTMLPreElement.h"

#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLPreElement)

/* Hash table */

static const HashTableValue JSHTMLPreElementTableValues[4] =
{
    { "width", DontDelete, (intptr_t)jsHTMLPreElementWidth, (intptr_t)setJSHTMLPreElementWidth },
    { "wrap", DontDelete, (intptr_t)jsHTMLPreElementWrap, (intptr_t)setJSHTMLPreElementWrap },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLPreElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLPreElementTable = { 15, JSHTMLPreElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLPreElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLPreElementConstructorTable = { 0, JSHTMLPreElementConstructorTableValues, 0 };

class JSHTMLPreElementConstructor : public DOMObject {
public:
    JSHTMLPreElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLPreElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLPreElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLPreElementConstructor::s_info = { "HTMLPreElementConstructor", 0, &JSHTMLPreElementConstructorTable, 0 };

bool JSHTMLPreElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLPreElementConstructor, DOMObject>(exec, &JSHTMLPreElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLPreElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLPreElementPrototypeTable = { 0, JSHTMLPreElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLPreElementPrototype::s_info = { "HTMLPreElementPrototype", 0, &JSHTMLPreElementPrototypeTable, 0 };

JSObject* JSHTMLPreElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLPreElement>(exec);
}

const ClassInfo JSHTMLPreElement::s_info = { "HTMLPreElement", &JSHTMLElement::s_info, &JSHTMLPreElementTable , 0 };

JSHTMLPreElement::JSHTMLPreElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLPreElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLPreElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLPreElementPrototype(JSHTMLPreElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLPreElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLPreElement, Base>(exec, &JSHTMLPreElementTable, this, propertyName, slot);
}

JSValue* jsHTMLPreElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLPreElement* imp = static_cast<HTMLPreElement*>(static_cast<JSHTMLPreElement*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->width());
}

JSValue* jsHTMLPreElementWrap(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLPreElement* imp = static_cast<HTMLPreElement*>(static_cast<JSHTMLPreElement*>(slot.slotBase())->impl());
    return jsBoolean(imp->wrap());
}

JSValue* jsHTMLPreElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLPreElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLPreElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLPreElement, Base>(exec, propertyName, value, &JSHTMLPreElementTable, this, slot);
}

void setJSHTMLPreElementWidth(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLPreElement* imp = static_cast<HTMLPreElement*>(static_cast<JSHTMLPreElement*>(thisObject)->impl());
    imp->setWidth(value->toInt32(exec));
}

void setJSHTMLPreElementWrap(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLPreElement* imp = static_cast<HTMLPreElement*>(static_cast<JSHTMLPreElement*>(thisObject)->impl());
    imp->setWrap(value->toBoolean(exec));
}

JSValue* JSHTMLPreElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLPreElementConstructor>(exec);
}


}
