/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLParamElement.h"

#include <wtf/GetPtr.h>

#include "HTMLParamElement.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLParamElement)

/* Hash table */

static const HashTableValue JSHTMLParamElementTableValues[6] =
{
    { "name", DontDelete, (intptr_t)jsHTMLParamElementName, (intptr_t)setJSHTMLParamElementName },
    { "type", DontDelete, (intptr_t)jsHTMLParamElementType, (intptr_t)setJSHTMLParamElementType },
    { "value", DontDelete, (intptr_t)jsHTMLParamElementValue, (intptr_t)setJSHTMLParamElementValue },
    { "valueType", DontDelete, (intptr_t)jsHTMLParamElementValueType, (intptr_t)setJSHTMLParamElementValueType },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLParamElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParamElementTable = { 127, JSHTMLParamElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLParamElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParamElementConstructorTable = { 0, JSHTMLParamElementConstructorTableValues, 0 };

class JSHTMLParamElementConstructor : public DOMObject {
public:
    JSHTMLParamElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLParamElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLParamElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLParamElementConstructor::s_info = { "HTMLParamElementConstructor", 0, &JSHTMLParamElementConstructorTable, 0 };

bool JSHTMLParamElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParamElementConstructor, DOMObject>(exec, &JSHTMLParamElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLParamElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParamElementPrototypeTable = { 0, JSHTMLParamElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLParamElementPrototype::s_info = { "HTMLParamElementPrototype", 0, &JSHTMLParamElementPrototypeTable, 0 };

JSObject* JSHTMLParamElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLParamElement>(exec);
}

const ClassInfo JSHTMLParamElement::s_info = { "HTMLParamElement", &JSHTMLElement::s_info, &JSHTMLParamElementTable , 0 };

JSHTMLParamElement::JSHTMLParamElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLParamElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLParamElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLParamElementPrototype(JSHTMLParamElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLParamElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParamElement, Base>(exec, &JSHTMLParamElementTable, this, propertyName, slot);
}

JSValue* jsHTMLParamElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->name());
}

JSValue* jsHTMLParamElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->type());
}

JSValue* jsHTMLParamElementValue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->value());
}

JSValue* jsHTMLParamElementValueType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->valueType());
}

JSValue* jsHTMLParamElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLParamElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLParamElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLParamElement, Base>(exec, propertyName, value, &JSHTMLParamElementTable, this, slot);
}

void setJSHTMLParamElementName(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(thisObject)->impl());
    imp->setName(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLParamElementType(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(thisObject)->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLParamElementValue(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(thisObject)->impl());
    imp->setValue(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLParamElementValueType(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLParamElement* imp = static_cast<HTMLParamElement*>(static_cast<JSHTMLParamElement*>(thisObject)->impl());
    imp->setValueType(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLParamElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLParamElementConstructor>(exec);
}


}
