/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLDocument.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "Element.h"
#include "HTMLCollection.h"
#include "HTMLDocument.h"
#include "JSElement.h"
#include "JSHTMLCollection.h"
#include "KURL.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDocument)

/* Hash table */

static const HashTableValue JSHTMLDocumentTableValues[17] =
{
    { "embeds", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentEmbeds, (intptr_t)0 },
    { "plugins", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentPlugins, (intptr_t)0 },
    { "scripts", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentScripts, (intptr_t)0 },
    { "all", 0, (intptr_t)jsHTMLDocumentAll, (intptr_t)setJSHTMLDocumentAll },
    { "width", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentHeight, (intptr_t)0 },
    { "dir", DontDelete, (intptr_t)jsHTMLDocumentDir, (intptr_t)setJSHTMLDocumentDir },
    { "designMode", DontDelete, (intptr_t)jsHTMLDocumentDesignMode, (intptr_t)setJSHTMLDocumentDesignMode },
    { "compatMode", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentCompatMode, (intptr_t)0 },
    { "activeElement", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentActiveElement, (intptr_t)0 },
    { "bgColor", DontDelete, (intptr_t)jsHTMLDocumentBgColor, (intptr_t)setJSHTMLDocumentBgColor },
    { "fgColor", DontDelete, (intptr_t)jsHTMLDocumentFgColor, (intptr_t)setJSHTMLDocumentFgColor },
    { "alinkColor", DontDelete, (intptr_t)jsHTMLDocumentAlinkColor, (intptr_t)setJSHTMLDocumentAlinkColor },
    { "linkColor", DontDelete, (intptr_t)jsHTMLDocumentLinkColor, (intptr_t)setJSHTMLDocumentLinkColor },
    { "vlinkColor", DontDelete, (intptr_t)jsHTMLDocumentVlinkColor, (intptr_t)setJSHTMLDocumentVlinkColor },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLDocumentConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDocumentTable = { 255, JSHTMLDocumentTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLDocumentConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDocumentConstructorTable = { 0, JSHTMLDocumentConstructorTableValues, 0 };

class JSHTMLDocumentConstructor : public DOMObject {
public:
    JSHTMLDocumentConstructor(ExecState* exec)
        : DOMObject(JSHTMLDocumentConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDocumentPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLDocumentConstructor::s_info = { "HTMLDocumentConstructor", 0, &JSHTMLDocumentConstructorTable, 0 };

bool JSHTMLDocumentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDocumentConstructor, DOMObject>(exec, &JSHTMLDocumentConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDocumentPrototypeTableValues[9] =
{
    { "open", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionOpen, (intptr_t)0 },
    { "close", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionClose, (intptr_t)0 },
    { "write", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionWrite, (intptr_t)1 },
    { "writeln", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionWriteln, (intptr_t)1 },
    { "clear", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionClear, (intptr_t)0 },
    { "captureEvents", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionCaptureEvents, (intptr_t)0 },
    { "releaseEvents", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionReleaseEvents, (intptr_t)0 },
    { "hasFocus", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionHasFocus, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDocumentPrototypeTable = { 31, JSHTMLDocumentPrototypeTableValues, 0 };

const ClassInfo JSHTMLDocumentPrototype::s_info = { "HTMLDocumentPrototype", 0, &JSHTMLDocumentPrototypeTable, 0 };

JSObject* JSHTMLDocumentPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLDocument>(exec);
}

bool JSHTMLDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLDocumentPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLDocument::s_info = { "HTMLDocument", &JSDocument::s_info, &JSHTMLDocumentTable , 0 };

JSHTMLDocument::JSHTMLDocument(PassRefPtr<StructureID> structure, PassRefPtr<HTMLDocument> impl)
    : JSDocument(structure, impl)
{
}

JSObject* JSHTMLDocument::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLDocumentPrototype(JSHTMLDocumentPrototype::createStructureID(JSDocumentPrototype::self(exec)));
}

bool JSHTMLDocument::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLDocument*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLDocument, Base>(exec, &JSHTMLDocumentTable, this, propertyName, slot);
}

JSValue* jsHTMLDocumentEmbeds(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->embeds()));
}

JSValue* jsHTMLDocumentPlugins(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->plugins()));
}

JSValue* jsHTMLDocumentScripts(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->scripts()));
}

JSValue* jsHTMLDocumentAll(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLDocument*>(slot.slotBase())->all(exec);
}

JSValue* jsHTMLDocumentWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->width());
}

JSValue* jsHTMLDocumentHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->height());
}

JSValue* jsHTMLDocumentDir(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsString(exec, imp->dir());
}

JSValue* jsHTMLDocumentDesignMode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsString(exec, imp->designMode());
}

JSValue* jsHTMLDocumentCompatMode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsString(exec, imp->compatMode());
}

JSValue* jsHTMLDocumentActiveElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->activeElement()));
}

JSValue* jsHTMLDocumentBgColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsString(exec, imp->bgColor());
}

JSValue* jsHTMLDocumentFgColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsString(exec, imp->fgColor());
}

JSValue* jsHTMLDocumentAlinkColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsString(exec, imp->alinkColor());
}

JSValue* jsHTMLDocumentLinkColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsString(exec, imp->linkColor());
}

JSValue* jsHTMLDocumentVlinkColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(slot.slotBase())->impl());
    return jsString(exec, imp->vlinkColor());
}

JSValue* jsHTMLDocumentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLDocument*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLDocument::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDocument, Base>(exec, propertyName, value, &JSHTMLDocumentTable, this, slot);
}

void setJSHTMLDocumentAll(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    static_cast<JSHTMLDocument*>(thisObject)->setAll(exec, value);
}

void setJSHTMLDocumentDir(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setDir(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentDesignMode(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setDesignMode(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentBgColor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setBgColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentFgColor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setFgColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentAlinkColor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setAlinkColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentLinkColor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setLinkColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentVlinkColor(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setVlinkColor(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLDocument::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLDocumentConstructor>(exec);
}

JSValue* jsHTMLDocumentPrototypeFunctionOpen(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisValue);
    return castedThisObj->open(exec, args);
}

JSValue* jsHTMLDocumentPrototypeFunctionClose(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisValue);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->close();
    return jsUndefined();
}

JSValue* jsHTMLDocumentPrototypeFunctionWrite(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisValue);
    return castedThisObj->write(exec, args);
}

JSValue* jsHTMLDocumentPrototypeFunctionWriteln(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisValue);
    return castedThisObj->writeln(exec, args);
}

JSValue* jsHTMLDocumentPrototypeFunctionClear(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisValue);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->clear();
    return jsUndefined();
}

JSValue* jsHTMLDocumentPrototypeFunctionCaptureEvents(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisValue);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->captureEvents();
    return jsUndefined();
}

JSValue* jsHTMLDocumentPrototypeFunctionReleaseEvents(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisValue);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->releaseEvents();
    return jsUndefined();
}

JSValue* jsHTMLDocumentPrototypeFunctionHasFocus(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(thisValue);
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());


    JSC::JSValue* result = jsBoolean(imp->hasFocus());
    return result;
}


}
