/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLDirectoryElement.h"

#include <wtf/GetPtr.h>

#include "HTMLDirectoryElement.h"

#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDirectoryElement)

/* Hash table */

static const HashTableValue JSHTMLDirectoryElementTableValues[3] =
{
    { "compact", DontDelete, (intptr_t)jsHTMLDirectoryElementCompact, (intptr_t)setJSHTMLDirectoryElementCompact },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLDirectoryElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementTable = { 3, JSHTMLDirectoryElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLDirectoryElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementConstructorTable = { 0, JSHTMLDirectoryElementConstructorTableValues, 0 };

class JSHTMLDirectoryElementConstructor : public DOMObject {
public:
    JSHTMLDirectoryElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLDirectoryElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDirectoryElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLDirectoryElementConstructor::s_info = { "HTMLDirectoryElementConstructor", 0, &JSHTMLDirectoryElementConstructorTable, 0 };

bool JSHTMLDirectoryElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDirectoryElementConstructor, DOMObject>(exec, &JSHTMLDirectoryElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDirectoryElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementPrototypeTable = { 0, JSHTMLDirectoryElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLDirectoryElementPrototype::s_info = { "HTMLDirectoryElementPrototype", 0, &JSHTMLDirectoryElementPrototypeTable, 0 };

JSObject* JSHTMLDirectoryElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLDirectoryElement>(exec);
}

const ClassInfo JSHTMLDirectoryElement::s_info = { "HTMLDirectoryElement", &JSHTMLElement::s_info, &JSHTMLDirectoryElementTable , 0 };

JSHTMLDirectoryElement::JSHTMLDirectoryElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLDirectoryElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLDirectoryElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLDirectoryElementPrototype(JSHTMLDirectoryElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLDirectoryElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDirectoryElement, Base>(exec, &JSHTMLDirectoryElementTable, this, propertyName, slot);
}

JSValue* jsHTMLDirectoryElementCompact(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDirectoryElement* imp = static_cast<HTMLDirectoryElement*>(static_cast<JSHTMLDirectoryElement*>(slot.slotBase())->impl());
    return jsBoolean(imp->compact());
}

JSValue* jsHTMLDirectoryElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLDirectoryElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLDirectoryElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDirectoryElement, Base>(exec, propertyName, value, &JSHTMLDirectoryElementTable, this, slot);
}

void setJSHTMLDirectoryElementCompact(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDirectoryElement* imp = static_cast<HTMLDirectoryElement*>(static_cast<JSHTMLDirectoryElement*>(thisObject)->impl());
    imp->setCompact(value->toBoolean(exec));
}

JSValue* JSHTMLDirectoryElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLDirectoryElementConstructor>(exec);
}


}
