/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLAppletElement.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "HTMLAppletElement.h"
#include "JSHTMLAppletElementCustom.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLAppletElement)

/* Hash table */

static const HashTableValue JSHTMLAppletElementTableValues[13] =
{
    { "align", DontDelete, (intptr_t)jsHTMLAppletElementAlign, (intptr_t)setJSHTMLAppletElementAlign },
    { "alt", DontDelete, (intptr_t)jsHTMLAppletElementAlt, (intptr_t)setJSHTMLAppletElementAlt },
    { "archive", DontDelete, (intptr_t)jsHTMLAppletElementArchive, (intptr_t)setJSHTMLAppletElementArchive },
    { "code", DontDelete, (intptr_t)jsHTMLAppletElementCode, (intptr_t)setJSHTMLAppletElementCode },
    { "codeBase", DontDelete, (intptr_t)jsHTMLAppletElementCodeBase, (intptr_t)setJSHTMLAppletElementCodeBase },
    { "height", DontDelete, (intptr_t)jsHTMLAppletElementHeight, (intptr_t)setJSHTMLAppletElementHeight },
    { "hspace", DontDelete, (intptr_t)jsHTMLAppletElementHspace, (intptr_t)setJSHTMLAppletElementHspace },
    { "name", DontDelete, (intptr_t)jsHTMLAppletElementName, (intptr_t)setJSHTMLAppletElementName },
    { "object", DontDelete, (intptr_t)jsHTMLAppletElementObject, (intptr_t)setJSHTMLAppletElementObject },
    { "vspace", DontDelete, (intptr_t)jsHTMLAppletElementVspace, (intptr_t)setJSHTMLAppletElementVspace },
    { "width", DontDelete, (intptr_t)jsHTMLAppletElementWidth, (intptr_t)setJSHTMLAppletElementWidth },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLAppletElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAppletElementTable = { 127, JSHTMLAppletElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLAppletElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAppletElementConstructorTable = { 0, JSHTMLAppletElementConstructorTableValues, 0 };

class JSHTMLAppletElementConstructor : public DOMObject {
public:
    JSHTMLAppletElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLAppletElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLAppletElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLAppletElementConstructor::s_info = { "HTMLAppletElementConstructor", 0, &JSHTMLAppletElementConstructorTable, 0 };

bool JSHTMLAppletElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAppletElementConstructor, DOMObject>(exec, &JSHTMLAppletElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLAppletElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAppletElementPrototypeTable = { 0, JSHTMLAppletElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLAppletElementPrototype::s_info = { "HTMLAppletElementPrototype", 0, &JSHTMLAppletElementPrototypeTable, 0 };

JSObject* JSHTMLAppletElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLAppletElement>(exec);
}

const ClassInfo JSHTMLAppletElement::s_info = { "HTMLAppletElement", &JSHTMLElement::s_info, &JSHTMLAppletElementTable , 0 };

JSHTMLAppletElement::JSHTMLAppletElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLAppletElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLAppletElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLAppletElementPrototype(JSHTMLAppletElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLAppletElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLAppletElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLAppletElement, Base>(exec, &JSHTMLAppletElementTable, this, propertyName, slot);
}

JSValue* jsHTMLAppletElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->align());
}

JSValue* jsHTMLAppletElementAlt(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->alt());
}

JSValue* jsHTMLAppletElementArchive(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->archive());
}

JSValue* jsHTMLAppletElementCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->code());
}

JSValue* jsHTMLAppletElementCodeBase(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->codeBase());
}

JSValue* jsHTMLAppletElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->height());
}

JSValue* jsHTMLAppletElementHspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->hspace());
}

JSValue* jsHTMLAppletElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->name());
}

JSValue* jsHTMLAppletElementObject(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->object());
}

JSValue* jsHTMLAppletElementVspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->vspace());
}

JSValue* jsHTMLAppletElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->width());
}

JSValue* jsHTMLAppletElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLAppletElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLAppletElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    if (customPut(exec, propertyName, value, slot))
        return;
    lookupPut<JSHTMLAppletElement, Base>(exec, propertyName, value, &JSHTMLAppletElementTable, this, slot);
}

void setJSHTMLAppletElementAlign(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementAlt(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setAlt(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementArchive(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setArchive(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementCode(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setCode(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementCodeBase(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setCodeBase(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementHeight(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setHeight(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementHspace(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setHspace(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementName(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setName(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementObject(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setObject(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementVspace(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setVspace(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLAppletElementWidth(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(static_cast<JSHTMLAppletElement*>(thisObject)->impl());
    imp->setWidth(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLAppletElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLAppletElementConstructor>(exec);
}


}
